/*
 * Decompiled with CFR 0.152.
 */
package treadle.executable;

import scala.Array$;
import scala.Function0;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import treadle.executable.DataStore;
import treadle.executable.RollBackBuffer;
import treadle.executable.TreadleException;

@ScalaSignature(bytes="\u0006\u0001e3A\u0001E\t\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0004'\u0001\t\u0007I\u0011A\u0014\t\r-\u0002\u0001\u0015!\u0003)\u0011\u001da\u0003A1A\u0005\u00025Ba\u0001\u000e\u0001!\u0002\u0013q\u0003bB\u001b\u0001\u0001\u0004%\ta\n\u0005\bm\u0001\u0001\r\u0011\"\u00018\u0011\u0019i\u0004\u0001)Q\u0005Q!9a\b\u0001a\u0001\n\u00039\u0003bB \u0001\u0001\u0004%\t\u0001\u0011\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u0015\t\u000b\r\u0003A\u0011A\u0014\t\u000b\u0011\u0003A\u0011A#\t\u000bI\u0003A\u0011A*\u0003%I{G\u000e\u001c\"bG.\u0014UO\u001a4feJKgn\u001a\u0006\u0003%M\t!\"\u001a=fGV$\u0018M\u00197f\u0015\u0005!\u0012a\u0002;sK\u0006$G.Z\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\nI\u0006$\u0018m\u0015;pe\u0016\u0004\"a\b\u0011\u000e\u0003EI!!I\t\u0003\u0013\u0011\u000bG/Y*u_J,\u0017A\u0002\u001fj]&$h\b\u0006\u0002%KA\u0011q\u0004\u0001\u0005\u0006;\t\u0001\rAH\u0001\u0010]Vl'-\u001a:PM\n+hMZ3sgV\t\u0001\u0006\u0005\u0002\u0019S%\u0011!&\u0007\u0002\u0004\u0013:$\u0018\u0001\u00058v[\n,'o\u00144Ck\u001a4WM]:!\u0003)\u0011\u0018N\\4Ck\u001a4WM]\u000b\u0002]A\u0019\u0001dL\u0019\n\u0005AJ\"!B!se\u0006L\bCA\u00103\u0013\t\u0019\u0014C\u0001\bS_2d')Y2l\u0005V4g-\u001a:\u0002\u0017ILgn\u001a\"vM\u001a,'\u000fI\u0001\u0012_2$Wm\u001d;Ck\u001a4WM]%oI\u0016D\u0018!F8mI\u0016\u001cHOQ;gM\u0016\u0014\u0018J\u001c3fq~#S-\u001d\u000b\u0003qm\u0002\"\u0001G\u001d\n\u0005iJ\"\u0001B+oSRDq\u0001\u0010\u0005\u0002\u0002\u0003\u0007\u0001&A\u0002yIE\n!c\u001c7eKN$()\u001e4gKJLe\u000eZ3yA\u0005\tB.\u0019;fgR\u0014UO\u001a4fe&sG-\u001a=\u0002+1\fG/Z:u\u0005V4g-\u001a:J]\u0012,\u0007p\u0018\u0013fcR\u0011\u0001(\u0011\u0005\by-\t\t\u00111\u0001)\u0003Ia\u0017\r^3ti\n+hMZ3s\u0013:$W\r\u001f\u0011\u0002-\r,(O]3oi:+XNY3s\u001f\u001a\u0014UO\u001a4feN\fQC\\3xKN$Hk\\(mI\u0016\u001cHOQ;gM\u0016\u00148/F\u0001G!\r9u*\r\b\u0003\u00116s!!\u0013'\u000e\u0003)S!aS\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012B\u0001(\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\u0007M+\u0017O\u0003\u0002O3\u00059\u0012\r\u001a<b]\u000e,\u0017I\u001c3HKRtU\r\u001f;Ck\u001a4WM\u001d\u000b\u0003cQCQ!V\bA\u0002Y\u000bA\u0001^5nKB\u0011\u0001dV\u0005\u00031f\u0011A\u0001T8oO\u0002")
public class RollBackBufferRing {
    private final DataStore dataStore;
    private final int numberOfBuffers;
    private final RollBackBuffer[] ringBuffer;
    private int oldestBufferIndex;
    private int latestBufferIndex;

    public int numberOfBuffers() {
        return this.numberOfBuffers;
    }

    public RollBackBuffer[] ringBuffer() {
        return this.ringBuffer;
    }

    public int oldestBufferIndex() {
        return this.oldestBufferIndex;
    }

    public void oldestBufferIndex_$eq(int x$1) {
        this.oldestBufferIndex = x$1;
    }

    public int latestBufferIndex() {
        return this.latestBufferIndex;
    }

    public void latestBufferIndex_$eq(int x$1) {
        this.latestBufferIndex = x$1;
    }

    public int currentNumberOfBuffers() {
        return this.numberOfBuffers() == 0 ? 0 : (this.latestBufferIndex() + this.numberOfBuffers() - this.oldestBufferIndex()) % this.numberOfBuffers();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<RollBackBuffer> newestToOldestBuffers() {
        void var1_1;
        block1: {
            List list = List$.MODULE$.empty();
            if (this.currentNumberOfBuffers() <= 0) break block1;
            int index = this.latestBufferIndex();
            while (index != this.oldestBufferIndex()) {
                list = (List)list.$colon$plus((Object)this.ringBuffer()[index], List$.MODULE$.canBuildFrom());
                if (--index >= 0) continue;
                index = this.numberOfBuffers() - 1;
            }
            list = (List)list.$colon$plus((Object)this.ringBuffer()[index], List$.MODULE$.canBuildFrom());
        }
        return var1_1;
    }

    public RollBackBuffer advanceAndGetNextBuffer(long time) {
        block4: {
            if (this.currentNumberOfBuffers() > 0 && time < this.ringBuffer()[this.latestBufferIndex()].time()) {
                throw new TreadleException("rollback buffer requested has earlier time that last used buffer");
            }
            if (this.currentNumberOfBuffers() != 0 && (this.currentNumberOfBuffers() <= 0 || time <= this.ringBuffer()[this.latestBufferIndex()].time())) break block4;
            this.latestBufferIndex_$eq(this.latestBufferIndex() + 1);
            if (this.latestBufferIndex() >= this.numberOfBuffers()) {
                this.latestBufferIndex_$eq(0);
            }
            if (this.latestBufferIndex() == this.oldestBufferIndex()) {
                this.oldestBufferIndex_$eq(this.oldestBufferIndex() + 1);
                if (this.oldestBufferIndex() >= this.numberOfBuffers()) {
                    this.oldestBufferIndex_$eq(0);
                }
            }
        }
        return this.ringBuffer()[this.latestBufferIndex()];
    }

    public RollBackBufferRing(DataStore dataStore) {
        this.dataStore = dataStore;
        this.numberOfBuffers = dataStore.numberOfBuffers();
        this.ringBuffer = (RollBackBuffer[])Array$.MODULE$.fill(this.numberOfBuffers(), (Function0 & java.io.Serializable & Serializable)() -> new RollBackBuffer($this.dataStore), ClassTag$.MODULE$.apply(RollBackBuffer.class));
        this.oldestBufferIndex = 0;
        this.latestBufferIndex = 0;
    }
}

