/*
 * Decompiled with CFR 0.152.
 */
package treadle.executable;

import firrtl.InstanceKind$;
import firrtl.NodeKind$;
import firrtl.PortKind$;
import firrtl.RegKind$;
import firrtl.WDefInstance;
import firrtl.WRef;
import firrtl.WSubField;
import firrtl.WSubIndex;
import firrtl.WireKind$;
import firrtl.graph.CyclicException;
import firrtl.ir.AsyncResetType$;
import firrtl.ir.Block;
import firrtl.ir.Circuit;
import firrtl.ir.ClockType$;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefMemory;
import firrtl.ir.DefModule;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Direction;
import firrtl.ir.DoPrim;
import firrtl.ir.EmptyStmt$;
import firrtl.ir.Expression;
import firrtl.ir.ExtModule;
import firrtl.ir.Info;
import firrtl.ir.Input$;
import firrtl.ir.IntWidth$;
import firrtl.ir.IsInvalid;
import firrtl.ir.Module;
import firrtl.ir.Mux;
import firrtl.ir.NoInfo$;
import firrtl.ir.Output$;
import firrtl.ir.Port;
import firrtl.ir.Print;
import firrtl.ir.SIntLiteral;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.Type;
import firrtl.ir.UIntLiteral;
import firrtl.ir.UIntType;
import firrtl.ir.ValidIf;
import java.io.Serializable;
import logger.LazyLogging;
import logger.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.BigInt$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import treadle.ScalaBlackBox;
import treadle.ScalaBlackBoxFactory;
import treadle.executable.IntSize$;
import treadle.executable.Memory$;
import treadle.executable.PrintInfo;
import treadle.executable.SensitivityGraphBuilder;
import treadle.executable.StopInfo;
import treadle.executable.StopOp$;
import treadle.executable.Symbol;
import treadle.executable.Symbol$;
import treadle.executable.SymbolTable;
import treadle.executable.TreadleException;
import treadle.executable.UnsignedInt$;
import treadle.utils.FindModule$;

public final class SymbolTable$
implements LazyLogging {
    public static SymbolTable$ MODULE$;
    private final String RegisterInputSuffix;
    private final String LastValueSuffix;
    private final String PrevSuffix;
    private final Logger logger;

    static {
        new SymbolTable$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String RegisterInputSuffix() {
        return this.RegisterInputSuffix;
    }

    public String LastValueSuffix() {
        return this.LastValueSuffix;
    }

    public String PrevSuffix() {
        return this.PrevSuffix;
    }

    public String makeRegisterInputName(String name) {
        return new StringBuilder(0).append(name).append(this.RegisterInputSuffix()).toString();
    }

    public String makeRegisterInputName(Symbol symbol) {
        return new StringBuilder(0).append(symbol.name()).append(this.RegisterInputSuffix()).toString();
    }

    public Symbol makeRegisterInputSymbol(Symbol symbol) {
        String x$1 = this.makeRegisterInputName(symbol);
        Type x$2 = symbol.firrtlType();
        WireKind$ x$3 = WireKind$.MODULE$;
        Info x$4 = symbol.info();
        int x$5 = Symbol$.MODULE$.apply$default$4();
        return Symbol$.MODULE$.apply(x$1, x$2, x$3, x$5, x$4);
    }

    public String makeLastValueName(String name) {
        return new StringBuilder(0).append(name).append(this.LastValueSuffix()).toString();
    }

    public String makeLastValueName(Symbol symbol) {
        return new StringBuilder(0).append(symbol.name()).append(this.LastValueSuffix()).toString();
    }

    public String makePreviousValue(String name) {
        return new StringBuilder(0).append(name).append(this.PrevSuffix()).toString();
    }

    public String makePreviousValue(Symbol symbol) {
        return new StringBuilder(0).append(symbol.name()).append(this.PrevSuffix()).toString();
    }

    public Symbol makeLastValueSymbol(Symbol symbol) {
        return Symbol$.MODULE$.apply(this.makeLastValueName(symbol), new UIntType(IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), Symbol$.MODULE$.apply$default$3(), Symbol$.MODULE$.apply$default$4(), Symbol$.MODULE$.apply$default$5());
    }

    public SymbolTable apply(HashMap<String, Symbol> nameToSymbol) {
        return new SymbolTable(nameToSymbol);
    }

    public SymbolTable apply(Circuit circuit, Seq<ScalaBlackBoxFactory> blackBoxFactories, boolean allowCycles) {
        Seq seq;
        Module module;
        IntRef stopSymbolsFound = IntRef.create((int)0);
        IntRef printSymbolsFound = IntRef.create((int)0);
        HashMap nameToSymbol = new HashMap();
        SensitivityGraphBuilder sensitivityGraphBuilder = new SensitivityGraphBuilder();
        HashSet instanceNames = new HashSet();
        HashSet registerNames = new HashSet();
        HashSet inputPorts = new HashSet();
        HashSet outputPorts = new HashSet();
        HashSet clockSignals = new HashSet();
        HashMap registerToClock = new HashMap();
        HashMap stopToStopInfo = new HashMap();
        HashMap instanceNameToModuleName = new HashMap();
        instanceNameToModuleName.update((Object)"", (Object)circuit.main());
        HashMap lastStopStymbol = new HashMap();
        HashMap printToPrintInfo = new HashMap();
        IntRef printfCardinal = IntRef.create((int)0);
        HashMap lastPrintfInMOdule = new HashMap();
        HashMap<String, HashSet<Symbol>> moduleMemoryToMemorySymbol = new HashMap<String, HashSet<Symbol>>(){

            public HashSet<Symbol> default(String key) {
                this.update(key, new HashSet());
                return (HashSet)this.apply(key);
            }
        };
        HashMap blackBoxImplementations = new HashMap();
        DefModule defModule = FindModule$.MODULE$.apply(circuit.main(), circuit);
        if (!(defModule instanceof Module)) {
            if (defModule instanceof ExtModule) {
                ExtModule extModule = (ExtModule)defModule;
                throw new TreadleException(new StringBuilder(42).append("Top level module must be a regular module ").append(extModule).toString());
            }
            throw new TreadleException(new StringBuilder(49).append("Top level module is not the right kind of module ").append(defModule).toString());
        }
        Module module2 = module = (Module)defModule;
        Module module3 = module2;
        this.logger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Build SymbolTable pass 1 -- gather starting");
        this.processModule$1("", module3, inputPorts, outputPorts, clockSignals, blackBoxFactories, nameToSymbol, registerNames, instanceNames, instanceNameToModuleName, circuit, blackBoxImplementations, registerToClock, sensitivityGraphBuilder, (HashMap)moduleMemoryToMemorySymbol, stopToStopInfo, lastStopStymbol, printfCardinal, printToPrintInfo, lastPrintfInMOdule, stopSymbolsFound, printSymbolsFound);
        this.logger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Build SymbolTable pass 1 -- gather complete: ").append(nameToSymbol.size()).append(" entries found").toString());
        SymbolTable symbolTable = this.apply((HashMap<String, Symbol>)nameToSymbol);
        symbolTable.instanceNames().$plus$plus$eq((TraversableOnce)instanceNames);
        symbolTable.instanceNameToModuleName().$plus$plus$eq((TraversableOnce)instanceNameToModuleName);
        symbolTable.registerNames().$plus$plus$eq((TraversableOnce)registerNames);
        symbolTable.inputPortsNames().$plus$plus$eq((TraversableOnce)inputPorts);
        symbolTable.outputPortsNames().$plus$plus$eq((TraversableOnce)outputPorts);
        symbolTable.treadle$executable$SymbolTable$$toBlackBoxImplementation().$plus$plus$eq((TraversableOnce)blackBoxImplementations);
        symbolTable.registerToClock().$plus$plus$eq((TraversableOnce)registerToClock);
        symbolTable.stopToStopInfo().$plus$plus$eq((TraversableOnce)stopToStopInfo);
        symbolTable.printToPrintInfo().$plus$plus$eq((TraversableOnce)printToPrintInfo);
        symbolTable.parentsOf_$eq(sensitivityGraphBuilder.getParentsOfDiGraph());
        symbolTable.childrenOf_$eq(sensitivityGraphBuilder.getChildrenOfDiGraph());
        symbolTable.moduleMemoryToMemorySymbol().$plus$plus$eq((TraversableOnce)moduleMemoryToMemorySymbol);
        try {
            seq = symbolTable.childrenOf().linearize();
        }
        catch (CyclicException e) {
            Symbol badNode = (Symbol)e.node();
            Predef$.MODULE$.println((Object)new StringBuilder(31).append("Combinational loop detected at ").append(badNode).toString());
            if (allowCycles) {
                seq = symbolTable.symbols().toSeq();
            }
            symbolTable.getChildren((Seq<Symbol>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{badNode})))).exists((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)SymbolTable$.$anonfun$apply$28(symbolTable, badNode, node)));
            throw e;
        }
        Seq sorted = seq;
        this.logger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Build SymbolTable pass 2 -- linearize complete");
        ((IterableLike)sorted.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SymbolTable$.$anonfun$apply$31(x0$1);
            return BoxedUnit.UNIT;
        });
        this.logger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Build SymbolTable pass 3 -- sort complete");
        symbolTable.orphans_$eq(sensitivityGraphBuilder.orphans(symbolTable));
        this.logger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Build Symbol table pass 4 -- find sources. ").append(symbolTable.orphans().length()).append(" non-input non-register sinks found").toString());
        this.logger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SymbolTable is built");
        return symbolTable;
    }

    public Seq<ScalaBlackBoxFactory> apply$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public boolean apply$default$3() {
        return false;
    }

    private static final String makeStopName$1(IntRef stopSymbolsFound$1) {
        ++stopSymbolsFound$1.elem;
        return new StringBuilder(5).append("/stop").append(stopSymbolsFound$1.elem - 1).toString();
    }

    private static final String makePrintName$1(IntRef printSymbolsFound$1) {
        ++printSymbolsFound$1.elem;
        return new StringBuilder(6).append("/print").append(printSymbolsFound$1.elem - 1).toString();
    }

    private static final void addSymbol$1(Symbol symbol, HashMap nameToSymbol$1) {
        if (nameToSymbol$1.contains((Object)symbol.name())) {
            throw new TreadleException(new StringBuilder(41).append("Symbol table attempting to re-add symbol ").append(symbol).toString());
        }
        nameToSymbol$1.update((Object)symbol.name(), (Object)symbol);
    }

    private static final void addDependency$1(Symbol sensitiveSymbol, scala.collection.immutable.Set drivingSymbols, SensitivityGraphBuilder sensitivityGraphBuilder$1) {
        drivingSymbols.foreach((Function1 & Serializable & scala.Serializable)drivingSymbol -> {
            sensitivityGraphBuilder$1.addSensitivity(drivingSymbol, sensitiveSymbol);
            return BoxedUnit.UNIT;
        });
    }

    private static final String expand$1(String name, String modulePrefix$1) {
        return modulePrefix$1.isEmpty() ? name : new StringBuilder(1).append(modulePrefix$1).append(".").append(name).toString();
    }

    private static final scala.collection.immutable.Set expressionToReferences$1(Expression expression, HashMap nameToSymbol$1, String modulePrefix$1) {
        scala.collection.immutable.Set set;
        Expression expression2 = expression;
        if (expression2 instanceof Mux) {
            Mux mux = (Mux)expression2;
            Expression condition = mux.cond();
            Expression trueExpression = mux.tval();
            Expression falseExpression = mux.fval();
            set = (scala.collection.immutable.Set)SymbolTable$.expressionToReferences$1(condition, nameToSymbol$1, modulePrefix$1).$plus$plus((GenTraversableOnce)SymbolTable$.expressionToReferences$1(trueExpression, nameToSymbol$1, modulePrefix$1)).$plus$plus((GenTraversableOnce)SymbolTable$.expressionToReferences$1(falseExpression, nameToSymbol$1, modulePrefix$1));
        } else {
            boolean bl = expression2 instanceof WRef ? true : (expression2 instanceof WSubField ? true : expression2 instanceof WSubIndex);
            if (bl) {
                String name = SymbolTable$.expand$1(expression.serialize(), modulePrefix$1);
                set = (scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{(Symbol)nameToSymbol$1.apply((Object)name)}));
            } else if (expression2 instanceof ValidIf) {
                ValidIf validIf = (ValidIf)expression2;
                Expression condition = validIf.cond();
                Expression value = validIf.value();
                set = (scala.collection.immutable.Set)SymbolTable$.expressionToReferences$1(condition, nameToSymbol$1, modulePrefix$1).$plus$plus((GenTraversableOnce)SymbolTable$.expressionToReferences$1(value, nameToSymbol$1, modulePrefix$1));
            } else if (expression2 instanceof DoPrim) {
                DoPrim doPrim = (DoPrim)expression2;
                Seq<Expression> args = doPrim.args();
                set = (scala.collection.immutable.Set)args.foldLeft((Object)scala.collection.immutable.Set$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    scala.collection.immutable.Set accum = (scala.collection.immutable.Set)tuple2._1();
                    Expression expr = (Expression)tuple2._2();
                    scala.collection.immutable.Set set = (scala.collection.immutable.Set)accum.$plus$plus((GenTraversableOnce)SymbolTable$.expressionToReferences$1(expr, nameToSymbol$1, modulePrefix$1));
                    return set;
                });
            } else {
                boolean bl2 = expression2 instanceof UIntLiteral ? true : expression2 instanceof SIntLiteral;
                if (bl2) {
                    set = scala.collection.immutable.Set$.MODULE$.empty();
                } else {
                    throw new Exception(new StringBuilder(51).append("expressionToReferences:error: unhandled expression ").append(expression).toString());
                }
            }
        }
        scala.collection.immutable.Set result = set;
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Symbol symbol) {
        Type type = symbol.firrtlType();
        ClockType$ clockType$ = ClockType$.MODULE$;
        return !(type != null ? !type.equals(clockType$) : clockType$ != null);
    }

    private static final Option getClockSymbol$1(Expression expression, HashMap nameToSymbol$1, String modulePrefix$1) {
        scala.collection.immutable.Set references = SymbolTable$.expressionToReferences$1(expression, nameToSymbol$1, modulePrefix$1);
        scala.collection.immutable.Set clocks = (scala.collection.immutable.Set)references.filter((Function1 & Serializable & scala.Serializable)symbol -> BoxesRunTime.boxToBoolean((boolean)SymbolTable$.$anonfun$apply$3(symbol)));
        return clocks.headOption();
    }

    private final void createPrevClock$1(String clockName, Type tpe, Info info, HashSet clockSignals$1, HashMap nameToSymbol$1) {
        block0: {
            String prevClockName;
            if (clockSignals$1.contains((Object)clockName)) break block0;
            clockSignals$1.add((Object)clockName);
            String x$1 = prevClockName = this.makePreviousValue(clockName);
            Type x$2 = tpe;
            NodeKind$ x$3 = NodeKind$.MODULE$;
            Info x$4 = info;
            int x$5 = Symbol$.MODULE$.apply$default$4();
            Symbol symbol = Symbol$.MODULE$.apply(x$1, x$2, x$3, x$5, x$4);
            SymbolTable$.addSymbol$1(symbol, nameToSymbol$1);
        }
    }

    private static final Symbol getSymbol$1(String name, HashMap nameToSymbol$1, String instanceName$1, String modulePrefix$1) {
        return (Symbol)nameToSymbol$1.apply((Object)SymbolTable$.expand$1(new StringBuilder(1).append(instanceName$1).append(".").append(name).toString(), modulePrefix$1));
    }

    public static final /* synthetic */ void $anonfun$apply$6(HashMap nameToSymbol$1, String instanceName$1, String modulePrefix$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String dependent = (String)tuple2._1();
        Set driving = (Set)tuple2._2();
        Symbol dependentSymbol = SymbolTable$.getSymbol$1(dependent, nameToSymbol$1, instanceName$1, modulePrefix$1);
        scala.collection.immutable.Set drivers = ((TraversableOnce)driving.map((Function1 & Serializable & scala.Serializable)name -> SymbolTable$.getSymbol$1(name, nameToSymbol$1, instanceName$1, modulePrefix$1), Set$.MODULE$.canBuildFrom())).toSet();
        SymbolTable$.addDependency$1(dependentSymbol, drivers, sensitivityGraphBuilder$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$apply$9(Symbol portSymbol$1, HashMap nameToSymbol$1, String instanceName$1, String modulePrefix$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, String inputName) {
        Symbol inputSymbol = SymbolTable$.getSymbol$1(inputName, nameToSymbol$1, instanceName$1, modulePrefix$1);
        SymbolTable$.addDependency$1(portSymbol$1, (scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{inputSymbol})), sensitivityGraphBuilder$1);
    }

    public static final /* synthetic */ void $anonfun$apply$8(ScalaBlackBox implementation$1, HashMap nameToSymbol$1, String instanceName$1, Symbol instanceSymbol$1, String modulePrefix$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, Port port) {
        block1: {
            Direction direction = port.direction();
            Output$ output$ = Output$.MODULE$;
            if (!(direction != null ? !direction.equals(output$) : output$ != null)) {
                Symbol portSymbol = SymbolTable$.getSymbol$1(port.name(), nameToSymbol$1, instanceName$1, modulePrefix$1);
                implementation$1.outputDependencies(port.name()).foreach((Function1 & Serializable & scala.Serializable)inputName -> {
                    SymbolTable$.$anonfun$apply$9(portSymbol, nameToSymbol$1, instanceName$1, modulePrefix$1, sensitivityGraphBuilder$1, inputName);
                    return BoxedUnit.UNIT;
                });
            }
            Type type = port.tpe();
            ClockType$ clockType$ = ClockType$.MODULE$;
            if (type != null ? !type.equals(clockType$) : clockType$ != null) break block1;
            Symbol portSymbol = (Symbol)nameToSymbol$1.apply((Object)SymbolTable$.expand$1(new StringBuilder(1).append(instanceName$1).append(".").append(port.name()).toString(), modulePrefix$1));
            SymbolTable$.addDependency$1(instanceSymbol$1, (scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{portSymbol})), sensitivityGraphBuilder$1);
        }
    }

    private final void processDependencyStatements$1(String modulePrefix, Statement s, Module module, HashMap nameToSymbol$1, HashSet clockSignals$1, HashSet registerNames$1, HashSet instanceNames$1, HashMap instanceNameToModuleName$1, Circuit circuit$1, HashMap blackBoxImplementations$1, HashMap registerToClock$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, HashMap moduleMemoryToMemorySymbol$1, HashMap stopToStopInfo$1, HashMap lastStopStymbol$1, IntRef printfCardinal$1, HashMap printToPrintInfo$1, HashMap lastPrintfInMOdule$1, HashSet inputPorts$1, HashSet outputPorts$1, Seq blackBoxFactories$1, IntRef stopSymbolsFound$1, IntRef printSymbolsFound$1) {
        Statement statement = s;
        if (statement instanceof Block) {
            Block block = (Block)statement;
            block.stmts().foreach((Function1 & Serializable & scala.Serializable)subStatement -> {
                this.processDependencyStatements$1(modulePrefix, subStatement, module, nameToSymbol$1, clockSignals$1, registerNames$1, instanceNames$1, instanceNameToModuleName$1, circuit$1, blackBoxImplementations$1, registerToClock$1, sensitivityGraphBuilder$1, moduleMemoryToMemorySymbol$1, stopToStopInfo$1, lastStopStymbol$1, printfCardinal$1, printToPrintInfo$1, lastPrintfInMOdule$1, inputPorts$1, outputPorts$1, blackBoxFactories$1, stopSymbolsFound$1, printSymbolsFound$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Connect) {
            Connect connect = (Connect)statement;
            Expression expression = connect.loc();
            boolean bl = expression instanceof WRef ? true : (expression instanceof WSubField ? true : expression instanceof WSubIndex);
            if (bl) {
                String name = registerNames$1.contains((Object)SymbolTable$.expand$1(connect.loc().serialize(), modulePrefix)) ? this.makeRegisterInputName(SymbolTable$.expand$1(connect.loc().serialize(), modulePrefix)) : SymbolTable$.expand$1(connect.loc().serialize(), modulePrefix);
                Symbol symbol2 = (Symbol)nameToSymbol$1.apply((Object)name);
                Type type = symbol2.firrtlType();
                ClockType$ clockType$ = ClockType$.MODULE$;
                if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
                    this.createPrevClock$1(symbol2.name(), symbol2.firrtlType(), symbol2.info(), clockSignals$1, nameToSymbol$1);
                }
                scala.collection.immutable.Set references = SymbolTable$.expressionToReferences$1(connect.expr(), nameToSymbol$1, modulePrefix);
                SymbolTable$.addDependency$1(symbol2, references, sensitivityGraphBuilder$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)new StringBuilder(58).append("Warning: connect at ").append(connect.info()).append(", ").append(connect.loc()).append(" is not WRef, WSubField or WSubIndex").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof WDefInstance) {
            WDefInstance wDefInstance = (WDefInstance)statement;
            Info info = wDefInstance.info();
            String instanceName = wDefInstance.name();
            String moduleName = wDefInstance.module();
            String expandedName = SymbolTable$.expand$1(instanceName, modulePrefix);
            instanceNames$1.$plus$eq((Object)expandedName);
            instanceNameToModuleName$1.update((Object)expandedName, (Object)moduleName);
            Symbol instanceSymbol = new Symbol(expandedName, IntSize$.MODULE$, UnsignedInt$.MODULE$, InstanceKind$.MODULE$, 1, 1, new UIntType(IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), info);
            SymbolTable$.addSymbol$1(instanceSymbol, nameToSymbol$1);
            DefModule subModule = FindModule$.MODULE$.apply(moduleName, circuit$1);
            String newPrefix = modulePrefix.isEmpty() ? instanceName : new StringBuilder(1).append(modulePrefix).append(".").append(instanceName).toString();
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("declaration:WDefInstance:").append(instanceName).append(":").append(moduleName).append(" prefix now ").append(newPrefix).toString());
            this.processModule$1(newPrefix, subModule, inputPorts$1, outputPorts$1, clockSignals$1, blackBoxFactories$1, nameToSymbol$1, registerNames$1, instanceNames$1, instanceNameToModuleName$1, circuit$1, blackBoxImplementations$1, registerToClock$1, sensitivityGraphBuilder$1, moduleMemoryToMemorySymbol$1, stopToStopInfo$1, lastStopStymbol$1, printfCardinal$1, printToPrintInfo$1, lastPrintfInMOdule$1, stopSymbolsFound$1, printSymbolsFound$1);
            DefModule defModule = subModule;
            if (defModule instanceof ExtModule) {
                ExtModule extModule = (ExtModule)defModule;
                Option option = blackBoxImplementations$1.get((Object)instanceSymbol);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ScalaBlackBox implementation = (ScalaBlackBox)some.value();
                    implementation.getDependencies().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        SymbolTable$.$anonfun$apply$6(nameToSymbol$1, instanceName, modulePrefix, sensitivityGraphBuilder$1, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    extModule.ports().foreach((Function1 & Serializable & scala.Serializable)port -> {
                        SymbolTable$.$anonfun$apply$8(implementation, nameToSymbol$1, instanceName, instanceSymbol, modulePrefix, sensitivityGraphBuilder$1, port);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Predef$.MODULE$.println((Object)new StringBuilder(68).append("WARNING: external module \"").append(extModule.defname()).append("\"(").append(modulePrefix).append(":").append(extModule.name()).append(")").append("was not matched with an implementation").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefNode) {
            BoxedUnit boxedUnit;
            String expandedName;
            DefNode defNode = (DefNode)statement;
            Info info = defNode.info();
            String name = defNode.name();
            Expression expression = defNode.value();
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("declaration:DefNode:").append(name).append(":").append(expression.serialize()).append(" ").append(SymbolTable$.expressionToReferences$1(expression, nameToSymbol$1, modulePrefix)).toString());
            String x$1 = expandedName = SymbolTable$.expand$1(name, modulePrefix);
            Type x$2 = expression.tpe();
            NodeKind$ x$3 = NodeKind$.MODULE$;
            Info x$4 = info;
            int x$5 = Symbol$.MODULE$.apply$default$4();
            Symbol symbol3 = Symbol$.MODULE$.apply(x$1, x$2, x$3, x$5, x$4);
            SymbolTable$.addSymbol$1(symbol3, nameToSymbol$1);
            SymbolTable$.addDependency$1(symbol3, SymbolTable$.expressionToReferences$1(expression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
            Type type = expression.tpe();
            ClockType$ clockType$ = ClockType$.MODULE$;
            if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
                this.createPrevClock$1(symbol3.name(), expression.tpe(), info, clockSignals$1, nameToSymbol$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (statement instanceof DefWire) {
            BoxedUnit boxedUnit;
            String expandedName;
            DefWire defWire = (DefWire)statement;
            Info info = defWire.info();
            String name = defWire.name();
            Type tpe = defWire.tpe();
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("declaration:DefWire:").append(name).toString());
            String x$6 = expandedName = SymbolTable$.expand$1(name, modulePrefix);
            Type x$7 = tpe;
            WireKind$ x$8 = WireKind$.MODULE$;
            Info x$9 = info;
            int x$10 = Symbol$.MODULE$.apply$default$4();
            Symbol symbol4 = Symbol$.MODULE$.apply(x$6, x$7, x$8, x$10, x$9);
            SymbolTable$.addSymbol$1(symbol4, nameToSymbol$1);
            Type type = tpe;
            ClockType$ clockType$ = ClockType$.MODULE$;
            if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
                this.createPrevClock$1(symbol4.name(), tpe, info, clockSignals$1, nameToSymbol$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            Info info = defRegister.info();
            String name = defRegister.name();
            Type tpe = defRegister.tpe();
            Expression clockExpression = defRegister.clock();
            Expression resetExpression = defRegister.reset();
            String expandedName = SymbolTable$.expand$1(name, modulePrefix);
            String x$11 = this.makeRegisterInputName(expandedName);
            Type x$12 = tpe;
            RegKind$ x$13 = RegKind$.MODULE$;
            Info x$14 = info;
            int x$15 = Symbol$.MODULE$.apply$default$4();
            Symbol registerIn = Symbol$.MODULE$.apply(x$11, x$12, x$13, x$15, x$14);
            String x$16 = expandedName;
            Type x$17 = tpe;
            RegKind$ x$18 = RegKind$.MODULE$;
            Info x$19 = info;
            int x$20 = Symbol$.MODULE$.apply$default$4();
            Symbol registerOut = Symbol$.MODULE$.apply(x$16, x$17, x$18, x$20, x$19);
            registerNames$1.$plus$eq((Object)registerOut.name());
            SymbolTable$.addSymbol$1(registerIn, nameToSymbol$1);
            SymbolTable$.addSymbol$1(registerOut, nameToSymbol$1);
            SymbolTable$.addDependency$1(registerOut, SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
            SymbolTable$.addDependency$1(registerIn, SymbolTable$.expressionToReferences$1(resetExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
            Type type = resetExpression.tpe();
            AsyncResetType$ asyncResetType$ = AsyncResetType$.MODULE$;
            if (!(type != null ? !type.equals(asyncResetType$) : asyncResetType$ != null)) {
                SymbolTable$.addDependency$1(registerOut, SymbolTable$.expressionToReferences$1(resetExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
            }
            SymbolTable$.addDependency$1(registerIn, (scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{registerOut})), sensitivityGraphBuilder$1);
            scala.collection.immutable.Set clocks = SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix);
            Predef$.MODULE$.assert(clocks.size() == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Register ").append(name).append(" needs to be clocked by exactly one wire: ").append(clocks).toString());
            Symbol clock = (Symbol)clocks.head();
            this.createPrevClock$1(clock.name(), clock.firrtlType(), clock.info(), clockSignals$1, nameToSymbol$1);
            registerToClock$1.update((Object)registerOut, (Object)clock);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefMemory) {
            DefMemory defMemory = (DefMemory)statement;
            String expandedName = SymbolTable$.expand$1(defMemory.name(), modulePrefix);
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("declaration:DefMemory:").append(defMemory.name()).append(" becomes ").append(expandedName).toString());
            Seq<Symbol> memorySymbols = Memory$.MODULE$.buildSymbols(defMemory, expandedName, sensitivityGraphBuilder$1, (HashSet<String>)registerNames$1);
            memorySymbols.foreach((Function1 & Serializable & scala.Serializable)symbol -> {
                SymbolTable$.addSymbol$1(symbol, nameToSymbol$1);
                return BoxedUnit.UNIT;
            });
            String moduleMemory = new StringBuilder(1).append(module.name()).append(".").append(defMemory.name()).toString();
            ((HashSet)moduleMemoryToMemorySymbol$1.apply((Object)moduleMemory)).$plus$eq(memorySymbols.head());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Stop) {
            BoxedUnit boxedUnit;
            Stop stop2 = (Stop)statement;
            Info info = stop2.info();
            Expression clockExpression = stop2.clk();
            Expression enableExpression = stop2.en();
            Option option = SymbolTable$.getClockSymbol$1(clockExpression, nameToSymbol$1, modulePrefix);
            if (option instanceof Some) {
                String stopSymbolName = SymbolTable$.makeStopName$1(stopSymbolsFound$1);
                Symbol stopSymbol = new Symbol(stopSymbolName, IntSize$.MODULE$, UnsignedInt$.MODULE$, WireKind$.MODULE$, 1, 1, new UIntType(IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), info);
                SymbolTable$.addSymbol$1(stopSymbol, nameToSymbol$1);
                stopToStopInfo$1.update((Object)stop2, (Object)new StopInfo(stopSymbol));
                SymbolTable$.addDependency$1(stopSymbol, SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                SymbolTable$.addDependency$1(stopSymbol, SymbolTable$.expressionToReferences$1(enableExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                Option option2 = lastStopStymbol$1.get((Object)module);
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Symbol lastSymbol = (Symbol)some.value();
                    SymbolTable$.addDependency$1(stopSymbol, (scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{lastSymbol})), sensitivityGraphBuilder$1);
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                }
                lastStopStymbol$1.update((Object)module, (Object)stopSymbol);
                if (!nameToSymbol$1.contains((Object)StopOp$.MODULE$.stopHappenedName())) {
                    SymbolTable$.addSymbol$1(new Symbol(StopOp$.MODULE$.stopHappenedName(), IntSize$.MODULE$, UnsignedInt$.MODULE$, WireKind$.MODULE$, 1, 1, new UIntType(IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(31))), NoInfo$.MODULE$), nameToSymbol$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new TreadleException(new StringBuilder(21).append("Can't find clock for ").append(stop2).toString());
            }
            BoxedUnit boxedUnit6 = boxedUnit;
            BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
        } else if (statement instanceof Print) {
            Symbol printSymbol;
            Print print = (Print)statement;
            Info info = print.info();
            Seq<Expression> args = print.args();
            Expression clockExpression = print.clk();
            Expression enableExpression = print.en();
            Option option = SymbolTable$.getClockSymbol$1(clockExpression, nameToSymbol$1, modulePrefix);
            if (option instanceof Some) {
                String printSymbolName = SymbolTable$.makePrintName$1(printSymbolsFound$1);
                printSymbol = new Symbol(printSymbolName, IntSize$.MODULE$, UnsignedInt$.MODULE$, WireKind$.MODULE$, 1, 1, new UIntType(IntWidth$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(1))), info);
                SymbolTable$.addSymbol$1(printSymbol, nameToSymbol$1);
                ++printfCardinal$1.elem;
                printToPrintInfo$1.update((Object)print, (Object)new PrintInfo(printSymbol, printfCardinal$1.elem));
                SymbolTable$.addDependency$1(printSymbol, SymbolTable$.expressionToReferences$1(clockExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                SymbolTable$.addDependency$1(printSymbol, SymbolTable$.expressionToReferences$1(enableExpression, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                args.foreach((Function1 & Serializable & scala.Serializable)arg -> {
                    SymbolTable$.addDependency$1(printSymbol, SymbolTable$.expressionToReferences$1(arg, nameToSymbol$1, modulePrefix), sensitivityGraphBuilder$1);
                    return BoxedUnit.UNIT;
                });
                Option option3 = lastPrintfInMOdule$1.get((Object)module);
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    Symbol lastPrintfSymbol = (Symbol)some.value();
                    SymbolTable$.addDependency$1(printSymbol, (scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{lastPrintfSymbol})), sensitivityGraphBuilder$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new TreadleException(new StringBuilder(21).append("Can't find clock for ").append(print).toString());
            }
            lastPrintfInMOdule$1.update((Object)module, (Object)printSymbol);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
        } else if (EmptyStmt$.MODULE$.equals(statement)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof IsInvalid) {
            IsInvalid isInvalid = (IsInvalid)statement;
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                Expression arg$macro$1 = isInvalid.expr();
                return new StringOps("IsInvalid found for %20s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}));
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (statement instanceof Conditionally) {
                Conditionally conditionally = (Conditionally)statement;
                throw new TreadleException(new StringBuilder(36).append("conditionally unsupported in engine ").append(conditionally).toString());
            }
            Predef$.MODULE$.println((Object)new StringBuilder(26).append("TODO: Unhandled statement ").append(s).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final String expand$2(String name, String modulePrefix$2) {
        return new StringBuilder(1).append(modulePrefix$2).append(".").append(name).toString();
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(Port outputPort) {
        Direction direction = outputPort.direction();
        Output$ output$ = Output$.MODULE$;
        return !(direction != null ? !direction.equals(output$) : output$ != null);
    }

    public static final /* synthetic */ void $anonfun$apply$19(HashMap nameToSymbol$1, ExtModule extModule$1, Port outputPort$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, String modulePrefix$2, String inputPortName) {
        Symbol drivingSymbol = (Symbol)nameToSymbol$1.getOrElse((Object)SymbolTable$.expand$2(inputPortName, modulePrefix$2), (Function0 & Serializable & scala.Serializable)() -> {
            throw new TreadleException(new StringBuilder(118).append("external module ").append(extModule$1.name()).append(" claims output ").append(SymbolTable$.expand$2(outputPort$1.name(), modulePrefix$2)).append(" depends on non-existent input ").append(inputPortName).append(",").append(" probably a bad name in override def outputDependencies").toString());
        });
        sensitivityGraphBuilder$1.addSensitivity(drivingSymbol, (Symbol)nameToSymbol$1.apply((Object)SymbolTable$.expand$2(outputPort$1.name(), modulePrefix$2)));
    }

    public static final /* synthetic */ void $anonfun$apply$18(ScalaBlackBox instance$1, HashMap nameToSymbol$1, ExtModule extModule$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, String modulePrefix$2, Port outputPort) {
        instance$1.outputDependencies(outputPort.name()).foreach((Function1 & Serializable & scala.Serializable)inputPortName -> {
            SymbolTable$.$anonfun$apply$19(nameToSymbol$1, extModule$1, outputPort, sensitivityGraphBuilder$1, modulePrefix$2, inputPortName);
            return BoxedUnit.UNIT;
        });
    }

    private static final void processExternalInstance$1(ExtModule extModule, String modulePrefix, ScalaBlackBox instance, HashMap nameToSymbol$1, HashMap blackBoxImplementations$1, SensitivityGraphBuilder sensitivityGraphBuilder$1) {
        Symbol instanceSymbol = (Symbol)nameToSymbol$1.apply((Object)modulePrefix);
        blackBoxImplementations$1.update((Object)instanceSymbol, (Object)instance);
        extModule.ports().withFilter((Function1 & Serializable & scala.Serializable)outputPort -> BoxesRunTime.boxToBoolean((boolean)SymbolTable$.$anonfun$apply$17(outputPort))).foreach((Function1 & Serializable & scala.Serializable)outputPort -> {
            SymbolTable$.$anonfun$apply$18(instance, nameToSymbol$1, extModule, sensitivityGraphBuilder$1, modulePrefix, outputPort);
            return BoxedUnit.UNIT;
        });
    }

    private static final String expand$3(String name, String modulePrefix$3) {
        return new StringOps(Predef$.MODULE$.augmentString(modulePrefix$3)).nonEmpty() ? new StringBuilder(1).append(modulePrefix$3).append(".").append(name).toString() : name;
    }

    public static final /* synthetic */ void $anonfun$apply$21(String modulePrefix$3, HashSet inputPorts$1, HashSet outputPorts$1, HashSet clockSignals$1, HashMap nameToSymbol$1, Port port) {
        block3: {
            Object object;
            String expandedName = SymbolTable$.expand$3(port.name(), modulePrefix$3);
            Symbol symbol = Symbol$.MODULE$.apply(expandedName, port.tpe(), PortKind$.MODULE$, Symbol$.MODULE$.apply$default$4(), Symbol$.MODULE$.apply$default$5());
            SymbolTable$.addSymbol$1(symbol, nameToSymbol$1);
            if (!modulePrefix$3.isEmpty()) break block3;
            Direction direction = port.direction();
            Input$ input$ = Input$.MODULE$;
            if (!(direction != null ? !direction.equals(input$) : input$ != null)) {
                object = inputPorts$1.$plus$eq((Object)symbol.name());
            } else {
                Direction direction2 = port.direction();
                Output$ output$ = Output$.MODULE$;
                object = !(direction2 != null ? !direction2.equals(output$) : output$ != null) ? outputPorts$1.$plus$eq((Object)symbol.name()) : BoxedUnit.UNIT;
            }
            Type type = port.tpe();
            ClockType$ clockType$ = ClockType$.MODULE$;
            if (!(type != null ? !type.equals(clockType$) : clockType$ != null)) {
                clockSignals$1.add((Object)symbol.name());
                Symbol prevClockSymbol = Symbol$.MODULE$.apply(MODULE$.makePreviousValue(symbol), ClockType$.MODULE$, PortKind$.MODULE$, Symbol$.MODULE$.apply$default$4(), Symbol$.MODULE$.apply$default$5());
                SymbolTable$.addSymbol$1(prevClockSymbol, nameToSymbol$1);
            }
        }
    }

    private static final void processPorts$1(DefModule module, String modulePrefix$3, HashSet inputPorts$1, HashSet outputPorts$1, HashSet clockSignals$1, HashMap nameToSymbol$1) {
        module.ports().foreach((Function1 & Serializable & scala.Serializable)port -> {
            SymbolTable$.$anonfun$apply$21(modulePrefix$3, inputPorts$1, outputPorts$1, clockSignals$1, nameToSymbol$1, port);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$apply$24(String modulePrefix$3, ExtModule x3$1, HashMap nameToSymbol$1, HashMap blackBoxImplementations$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, ScalaBlackBoxFactory factory) {
        boolean bl;
        MODULE$.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Found an existing factory");
        Option<ScalaBlackBox> option = factory.createInstance(modulePrefix$3, x3$1.defname());
        if (option instanceof Some) {
            Some some = (Some)option;
            ScalaBlackBox implementation = (ScalaBlackBox)some.value();
            SymbolTable$.processExternalInstance$1(x3$1, modulePrefix$3, implementation, nameToSymbol$1, blackBoxImplementations$1, sensitivityGraphBuilder$1);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void processModule$1(String modulePrefix, DefModule myModule, HashSet inputPorts$1, HashSet outputPorts$1, HashSet clockSignals$1, Seq blackBoxFactories$1, HashMap nameToSymbol$1, HashSet registerNames$1, HashSet instanceNames$1, HashMap instanceNameToModuleName$1, Circuit circuit$1, HashMap blackBoxImplementations$1, HashMap registerToClock$1, SensitivityGraphBuilder sensitivityGraphBuilder$1, HashMap moduleMemoryToMemorySymbol$1, HashMap stopToStopInfo$1, HashMap lastStopStymbol$1, IntRef printfCardinal$1, HashMap printToPrintInfo$1, HashMap lastPrintfInMOdule$1, IntRef stopSymbolsFound$1, IntRef printSymbolsFound$1) {
        DefModule defModule = myModule;
        if (defModule instanceof Module) {
            Module module = (Module)defModule;
            SymbolTable$.processPorts$1(module, modulePrefix, inputPorts$1, outputPorts$1, clockSignals$1, nameToSymbol$1);
            this.processDependencyStatements$1(modulePrefix, module.body(), module, nameToSymbol$1, clockSignals$1, registerNames$1, instanceNames$1, instanceNameToModuleName$1, circuit$1, blackBoxImplementations$1, registerToClock$1, sensitivityGraphBuilder$1, moduleMemoryToMemorySymbol$1, stopToStopInfo$1, lastStopStymbol$1, printfCardinal$1, printToPrintInfo$1, lastPrintfInMOdule$1, inputPorts$1, outputPorts$1, blackBoxFactories$1, stopSymbolsFound$1, printSymbolsFound$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (defModule instanceof ExtModule) {
            BoxedUnit boxedUnit;
            ExtModule extModule = (ExtModule)defModule;
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("got external module ").append(extModule.name()).append(" instance ").append(modulePrefix).toString());
            SymbolTable$.processPorts$1(extModule, modulePrefix, inputPorts$1, outputPorts$1, clockSignals$1, nameToSymbol$1);
            this.logger().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Factories: ").append(blackBoxFactories$1.mkString("\n")).toString());
            boolean implementationFound = blackBoxFactories$1.exists((Function1 & Serializable & scala.Serializable)factory -> BoxesRunTime.boxToBoolean((boolean)SymbolTable$.$anonfun$apply$24(modulePrefix, extModule, nameToSymbol$1, blackBoxImplementations$1, sensitivityGraphBuilder$1, factory)));
            if (!implementationFound) {
                Predef$.MODULE$.println((Object)new StringBuilder(68).append("WARNING: external module \"").append(extModule.defname()).append("\"(").append(modulePrefix).append(":").append(extModule.name()).append(")").append("was not matched with an implementation").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)defModule);
        }
    }

    public static final /* synthetic */ boolean $anonfun$apply$28(SymbolTable symbolTable$1, Symbol badNode$1, Symbol node) {
        boolean bl;
        try {
            Seq<Symbol> path = symbolTable$1.childrenOf().path(node, badNode$1);
            Predef$.MODULE$.println((Object)new StringBuilder(19).append("Problem path:\n  ").append(badNode$1.name()).append("\n  ").append(((TraversableOnce)path.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString("\n  ")).toString());
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$apply$31(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Symbol symbol = (Symbol)tuple2._1();
        int index = tuple2._2$mcI$sp();
        int adjustedIndex = symbol.name().startsWith("/stopped") ? Integer.MAX_VALUE : (symbol.name().startsWith("/stop") ? 0x7FFFFFFE : index);
        symbol.cardinalNumber_$eq(adjustedIndex);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SymbolTable$() {
        MODULE$ = this;
        LazyLogging.$init$(this);
        this.RegisterInputSuffix = "/in";
        this.LastValueSuffix = "/last";
        this.PrevSuffix = "/prev";
    }
}

