/*
 * Decompiled with CFR 0.152.
 */
package xyz.kotlinw.eventbus.inprocess;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.kotlinw.eventbus.inprocess.EventBusBufferOverflowException;
import xyz.kotlinw.eventbus.inprocess.EventBusBufferOverflowStrategy;
import xyz.kotlinw.eventbus.inprocess.InProcessEventBus;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u00060\u0002j\u0002`\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0019\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lxyz/kotlinw/eventbus/inprocess/InProcessEventBusImpl;", "E", "", "Lxyz/kotlinw/eventbus/inprocess/LocalEvent;", "Lxyz/kotlinw/eventbus/inprocess/InProcessEventBus;", "bufferCapacity", "", "bufferOverflowStrategy", "Lxyz/kotlinw/eventbus/inprocess/EventBusBufferOverflowStrategy;", "(ILxyz/kotlinw/eventbus/inprocess/EventBusBufferOverflowStrategy;)V", "_events", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "events", "Lkotlinx/coroutines/flow/SharedFlow;", "isRejectOnBufferOverflow", "", "Lkotlinx/coroutines/flow/Flow;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publish", "", "event", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kotlinw-eventbus-inprocess"})
public final class InProcessEventBusImpl<E>
implements InProcessEventBus<E> {
    @NotNull
    private final MutableSharedFlow<E> _events;
    private final boolean isRejectOnBufferOverflow;
    @NotNull
    private final SharedFlow<E> events;

    public InProcessEventBusImpl(int bufferCapacity, @NotNull EventBusBufferOverflowStrategy bufferOverflowStrategy) {
        BufferOverflow bufferOverflow;
        Intrinsics.checkNotNullParameter((Object)((Object)bufferOverflowStrategy), (String)"bufferOverflowStrategy");
        if (!(bufferCapacity >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[bufferOverflowStrategy.ordinal()]) {
            case 1: {
                bufferOverflow = BufferOverflow.SUSPEND;
                break;
            }
            case 2: {
                bufferOverflow = BufferOverflow.DROP_OLDEST;
                break;
            }
            case 3: {
                bufferOverflow = BufferOverflow.DROP_LATEST;
                break;
            }
            case 4: {
                bufferOverflow = BufferOverflow.SUSPEND;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this._events = SharedFlowKt.MutableSharedFlow$default((int)0, (int)bufferCapacity, (BufferOverflow)bufferOverflow, (int)1, null);
        this.isRejectOnBufferOverflow = bufferOverflowStrategy == EventBusBufferOverflowStrategy.REJECT;
        this.events = FlowKt.asSharedFlow(this._events);
    }

    public /* synthetic */ InProcessEventBusImpl(int n, EventBusBufferOverflowStrategy eventBusBufferOverflowStrategy, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        if ((n2 & 2) != 0) {
            eventBusBufferOverflowStrategy = EventBusBufferOverflowStrategy.SUSPEND;
        }
        this(n, eventBusBufferOverflowStrategy);
    }

    @Override
    @Nullable
    public Object publish(@NotNull E event, @NotNull Continuation<? super Unit> $completion) {
        if (!this._events.tryEmit(event)) {
            if (this.isRejectOnBufferOverflow) {
                throw new EventBusBufferOverflowException();
            }
            Object object = this._events.emit(event, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object events(@NotNull Continuation<? super Flow<? extends E>> $completion) {
        return this.events;
    }

    public InProcessEventBusImpl() {
        this(0, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventBusBufferOverflowStrategy.values().length];
            try {
                nArray[EventBusBufferOverflowStrategy.SUSPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventBusBufferOverflowStrategy.DROP_OLDEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventBusBufferOverflowStrategy.DROP_LATEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventBusBufferOverflowStrategy.REJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

