/*
 * Decompiled with CFR 0.152.
 */
package xyz.kotlinw.oauth2.ktor.client;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J!\u0010\u0011\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lxyz/kotlinw/oauth2/ktor/client/OAuth2AccessTokenData;", "", "accessToken", "", "Lxyz/kotlinw/oauth2/core/OAuth2AccessToken;", "expiryTimestamp", "Lkotlinx/datetime/Instant;", "(Ljava/lang/String;Lkotlinx/datetime/Instant;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiryTimestamp", "()Lkotlinx/datetime/Instant;", "isExpired", "", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "kotlinw-oauth2-ktor-client"})
final class OAuth2AccessTokenData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accessToken;
    @NotNull
    private final Instant expiryTimestamp;
    @NotNull
    private static final OAuth2AccessTokenData Expired = new OAuth2AccessTokenData("", Instant.Companion.getDISTANT_PAST());

    public OAuth2AccessTokenData(@NotNull String accessToken, @NotNull Instant expiryTimestamp) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)expiryTimestamp, (String)"expiryTimestamp");
        this.accessToken = accessToken;
        this.expiryTimestamp = expiryTimestamp;
    }

    @NotNull
    public final String getAccessToken() {
        return this.accessToken;
    }

    @NotNull
    public final Instant getExpiryTimestamp() {
        return this.expiryTimestamp;
    }

    public final boolean isExpired() {
        return this.expiryTimestamp.compareTo(Clock.System.INSTANCE.now()) < 0;
    }

    @NotNull
    public final String component1() {
        return this.accessToken;
    }

    @NotNull
    public final Instant component2() {
        return this.expiryTimestamp;
    }

    @NotNull
    public final OAuth2AccessTokenData copy(@NotNull String accessToken, @NotNull Instant expiryTimestamp) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullParameter((Object)expiryTimestamp, (String)"expiryTimestamp");
        return new OAuth2AccessTokenData(accessToken, expiryTimestamp);
    }

    public static /* synthetic */ OAuth2AccessTokenData copy$default(OAuth2AccessTokenData oAuth2AccessTokenData, String string, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            string = oAuth2AccessTokenData.accessToken;
        }
        if ((n & 2) != 0) {
            instant = oAuth2AccessTokenData.expiryTimestamp;
        }
        return oAuth2AccessTokenData.copy(string, instant);
    }

    @NotNull
    public String toString() {
        return "OAuth2AccessTokenData(accessToken=" + this.accessToken + ", expiryTimestamp=" + this.expiryTimestamp + ")";
    }

    public int hashCode() {
        int result = this.accessToken.hashCode();
        result = result * 31 + this.expiryTimestamp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OAuth2AccessTokenData)) {
            return false;
        }
        OAuth2AccessTokenData oAuth2AccessTokenData = (OAuth2AccessTokenData)other;
        if (!Intrinsics.areEqual((Object)this.accessToken, (Object)oAuth2AccessTokenData.accessToken)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expiryTimestamp, (Object)oAuth2AccessTokenData.expiryTimestamp);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/kotlinw/oauth2/ktor/client/OAuth2AccessTokenData$Companion;", "", "()V", "Expired", "Lxyz/kotlinw/oauth2/ktor/client/OAuth2AccessTokenData;", "getExpired", "()Lxyz/kotlinw/oauth2/ktor/client/OAuth2AccessTokenData;", "kotlinw-oauth2-ktor-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OAuth2AccessTokenData getExpired() {
            return Expired;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

