/*
 * Decompiled with CFR 0.152.
 */
package cn.lijunyi.logtracing.aspect;

import cn.lijunyi.logtracing.aspect.annotation.SysLog;
import cn.lijunyi.logtracing.aspect.enums.HttpMethod;
import cn.lijunyi.logtracing.config.factory.LogJsonParserFactory;
import cn.lijunyi.logtracing.entity.BaseLogEntity;
import cn.lijunyi.logtracing.entity.BaseUserEntity;
import cn.lijunyi.logtracing.service.IOperationLogService;
import cn.lijunyi.logtracing.util.LogArrayUtils;
import cn.lijunyi.logtracing.util.LogIpUtils;
import cn.lijunyi.logtracing.util.LogServletUtils;
import cn.lijunyi.logtracing.util.LogStringUtils;
import cn.lijunyi.logtracing.util.constant.JsonParserConstant;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private static final ThreadLocal<Long> TIME_THREADLOCAL = new NamedThreadLocal("Cost Time");
    private final IOperationLogService operationLogService;
    private final LogJsonParserFactory jsonParserFactory;

    public LogAspect(IOperationLogService operationLogService, LogJsonParserFactory jsonParserFactory) {
        this.operationLogService = operationLogService;
        this.jsonParserFactory = jsonParserFactory;
    }

    @Before(value="@annotation(sysLog)")
    public void doBeforeProcessing(JoinPoint joinPoint, SysLog sysLog) {
        TIME_THREADLOCAL.set(System.currentTimeMillis());
    }

    @AfterReturning(pointcut="@annotation(sysLog)", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, SysLog sysLog, Object result) {
        this.recordOperationLog(joinPoint, sysLog, null, result);
    }

    @AfterThrowing(value="@annotation(sysLog)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, SysLog sysLog, Exception e) {
        this.recordOperationLog(joinPoint, sysLog, e, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordOperationLog(JoinPoint joinPoint, SysLog sysLog, Exception e, Object result) {
        try {
            BaseLogEntity baseLogEntity = new BaseLogEntity();
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            BaseUserEntity user = this.operationLogService.getSysUserInfo();
            String operateIp = LogStringUtils.isEmpty(user.getOperateIp()) ? LogIpUtils.getIpAddr() : user.getOperateIp();
            Integer operatorType = Optional.ofNullable(user.getOperatorType()).orElse(sysLog.operatorType());
            baseLogEntity.setRequestUrl(LogStringUtils.substring(LogServletUtils.getRequest().getRequestURI(), 0, 255)).setMethod(className + "." + methodName + "()").setRequestMethod(LogServletUtils.getRequest().getMethod()).setOperateIp(operateIp).setOperateTime(new Date()).setOperateUserId(user.getOperateUserId()).setOperatorType(operatorType).setOperateUserName(user.getOperateUserName()).setOperateDeptName(user.getOperateDeptName()).setErrorMsg("");
            if (e != null) {
                baseLogEntity.setErrorMsg(LogStringUtils.substring(e.getMessage(), 0, 2000));
            }
            this.getLogAnnotationInformation(joinPoint, sysLog, baseLogEntity, result);
            baseLogEntity.setCostTime(System.currentTimeMillis() - TIME_THREADLOCAL.get());
            this.operationLogService.recordOperateLog(baseLogEntity);
        }
        catch (Exception exp) {
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
        finally {
            TIME_THREADLOCAL.remove();
        }
    }

    private void getLogAnnotationInformation(JoinPoint joinPoint, SysLog sysLog, BaseLogEntity baseLogEntity, Object result) {
        baseLogEntity.setOperateModule(sysLog.operateModule()).setBusinessType(sysLog.businessType()).setOperateDescription(sysLog.operateDescription());
        if (sysLog.isSaveRequestData()) {
            this.setRequestValue(joinPoint, baseLogEntity, this.getExcludeProperties(sysLog.excludeParamNames()));
        }
        if (sysLog.isSaveResponseData() && LogStringUtils.isNotNull(result)) {
            baseLogEntity.setJsonResult(LogStringUtils.substring(this.jsonParserFactory.getParser().toJSONString(result, this.getExcludeProperties(sysLog.excludeParamNames())), 0, 2000));
        }
    }

    private void setRequestValue(JoinPoint joinPoint, BaseLogEntity baseLogEntity, String[] excludeParamNames) {
        String requestMethod = baseLogEntity.getRequestMethod();
        Map<String, String> paramsMap = LogServletUtils.getParamMap((ServletRequest)LogServletUtils.getRequest());
        if (LogStringUtils.isEmpty(paramsMap) && (HttpMethod.PUT.name().equals(requestMethod) || HttpMethod.POST.name().equals(requestMethod))) {
            String params = this.argsArrayToString(joinPoint.getArgs(), excludeParamNames);
            baseLogEntity.setRequestParam(LogStringUtils.substring(params, 0, 2000));
        } else {
            baseLogEntity.setRequestParam(LogStringUtils.substring(this.jsonParserFactory.getParser().toJSONString(paramsMap, excludeParamNames), 0, 2000));
        }
    }

    private String argsArrayToString(Object[] paramsArray, String[] excludeParamNames) {
        StringBuilder params = new StringBuilder();
        if (paramsArray != null) {
            for (Object o : paramsArray) {
                if (!LogStringUtils.isNotNull(o) || this.isFilterObject(o)) continue;
                try {
                    String jsonObj = this.jsonParserFactory.getParser().toJSONString(o, excludeParamNames);
                    params.append(jsonObj).append(" ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return params.toString().trim();
    }

    private String[] getExcludeProperties(String[] excludeParamNames) {
        return LogArrayUtils.addAll(JsonParserConstant.EXCLUDE_PROPERTIES, excludeParamNames);
    }

    public boolean isFilterObject(Object o) {
        Map map;
        Iterator iterator;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iterator2 = collection.iterator();
            if (iterator2.hasNext()) {
                Object value = iterator2.next();
                return value instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iterator = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry value;
            Map.Entry entry = value = iterator.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }
}

