/*
 * Decompiled with CFR 0.152.
 */
package cn.lijunyi.logtracing.aspect.enums;

import java.util.function.Function;

public enum SensitiveStrategy {
    USERNAME(s -> s.replaceAll("(\\S)\\S(\\S*)", "$1*$2")),
    PASSWORD(s -> s.replaceAll("\\d|\\w", "*")),
    PHONE(s -> s.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2")),
    EMAIL(s -> s.replaceAll("(^\\w)[^@]*(@.*$)", "$1****$2")),
    ID_CARD(s -> s.replaceAll("(\\d{4})\\d{10}(\\w{4})", "$1****$2")),
    BANK_CARD(s -> s.replaceAll("(\\d{6})\\d{9}(\\d{4})", "$1****$2")),
    ADDRESS(s -> s.replaceAll("(\\S{3})\\S{2}(\\S*)\\S{2}", "$1****$2****"));

    private final Function<String, String> desensitizer;

    private SensitiveStrategy(Function<String, String> desensitizer) {
        this.desensitizer = desensitizer;
    }

    public Function<String, String> desensitizer() {
        return this.desensitizer;
    }
}

