/*
 * Decompiled with CFR 0.152.
 */
package cn.lijunyi.logtracing.config.factory;

import cn.lijunyi.logtracing.config.autoconfigure.JsonParserProperties;
import cn.lijunyi.logtracing.service.ILogJsonParser;
import cn.lijunyi.logtracing.service.impl.FastJson2Parser;
import cn.lijunyi.logtracing.service.impl.JacksonParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogJsonParserFactory {
    private final FastJson2Parser fastJson2Parser;
    private final JacksonParser jacksonParser;
    private final JsonParserProperties jsonParserProperties;

    @Autowired(required=false)
    public LogJsonParserFactory(FastJson2Parser fastJson2Parser, JacksonParser jacksonParser, JsonParserProperties jsonParserProperties) {
        this.fastJson2Parser = fastJson2Parser;
        this.jacksonParser = jacksonParser;
        this.jsonParserProperties = jsonParserProperties;
    }

    public ILogJsonParser getParser() {
        String jsonParserName = this.jsonParserProperties.getJsonParserName();
        if ("fastjson2".equals(jsonParserName)) {
            return this.fastJson2Parser;
        }
        if ("jackson".equals(jsonParserName)) {
            return this.jacksonParser;
        }
        return this.jacksonParser;
    }
}

