/*
 * Decompiled with CFR 0.152.
 */
package cn.lijunyi.logtracing.service.impl;

import cn.lijunyi.logtracing.filter.PropertyPreExcludeFilter;
import cn.lijunyi.logtracing.service.ILogJsonParser;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={JSON.class})
public class FastJson2Parser
implements ILogJsonParser {
    private static final Logger log = LoggerFactory.getLogger(FastJson2Parser.class);

    @Override
    public String toJSONString(Object o, String[] excludeParamNames) {
        log.info("use FastJson2Parser Serialize Java Object to JSON");
        return JSON.toJSONString((Object)o, (Filter)this.excludePropertyPreFilter(excludeParamNames), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    public PropertyPreExcludeFilter excludePropertyPreFilter(String[] excludeParamNames) {
        return new PropertyPreExcludeFilter().addExcludes(excludeParamNames);
    }
}

