/*
 * Decompiled with CFR 0.152.
 */
package cn.lijunyi.logtracing.util;

import cn.lijunyi.logtracing.util.LogServletUtils;
import cn.lijunyi.logtracing.util.LogStringUtils;
import javax.servlet.http.HttpServletRequest;

public class LogIpUtils {
    private static final String COMMA = ",";
    private static final String IP = "127.0.0.1";
    private static final String LOCAL_IP = "0:0:0:0:0:0:0:1";
    private static final String HEADER = "x-forwarded-for";
    private static final String UNKNOWN = "unknown";
    private static final String WL_IP = "WL-Proxy-Client-IP";

    public static String getIpAddr() {
        return LogIpUtils.getIpAddr(LogServletUtils.getRequest());
    }

    public static String getIpAddr(HttpServletRequest request) {
        if (request == null) {
            return UNKNOWN;
        }
        String ip = request.getHeader(HEADER);
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader(WL_IP);
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return LOCAL_IP.equals(ip) ? IP : LogIpUtils.getMultistageReverseProxyIp(ip);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(COMMA) >= 1) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(COMMA)) {
                if (LogIpUtils.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return LogStringUtils.substring(ip, 0, 255);
    }

    public static boolean isUnknown(String checkString) {
        return LogStringUtils.isBlank(checkString) || UNKNOWN.equalsIgnoreCase(checkString);
    }
}

