/*
 * Decompiled with CFR 0.152.
 */
package cn.lijunyi.logtracing.util;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class LogStringUtils {
    public static final String EMPTY = "";

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String join(Object[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        return LogStringUtils.join(array, delimiter, 0, array.length);
    }

    public static String join(Object[] array, String delimiter, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringJoiner joiner = new StringJoiner(LogStringUtils.toStringOrEmpty(delimiter));
        for (int i = startIndex; i < endIndex; ++i) {
            joiner.add(LogStringUtils.toStringOrEmpty(array[i]));
        }
        return joiner.toString();
    }

    private static String toStringOrEmpty(Object obj) {
        return Objects.toString(obj, EMPTY);
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return !LogStringUtils.isNull(object);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return LogStringUtils.isNull(map) || map.isEmpty();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !LogStringUtils.isEmpty(str);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = LogStringUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }
}

