/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.reflectasm;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.WeakHashMap;
import xyz.noark.reflectasm.MethodAccess;

class AccessClassLoader
extends ClassLoader {
    private static final WeakHashMap<ClassLoader, WeakReference<AccessClassLoader>> ACCESS_CLASS_LOADERS = new WeakHashMap();
    private static final ClassLoader SELF_CONTEXT_PARENT_CLASS_LOADER = AccessClassLoader.getParentClassLoader(AccessClassLoader.class);
    private static volatile AccessClassLoader SELF_CONTEXT_ACCESS_CLASS_LOADER = new AccessClassLoader(SELF_CONTEXT_PARENT_CLASS_LOADER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AccessClassLoader get(Class<?> type) {
        ClassLoader parent = AccessClassLoader.getParentClassLoader(type);
        if (SELF_CONTEXT_PARENT_CLASS_LOADER.equals(parent)) {
            if (SELF_CONTEXT_ACCESS_CLASS_LOADER == null) {
                WeakHashMap<ClassLoader, WeakReference<AccessClassLoader>> weakHashMap = ACCESS_CLASS_LOADERS;
                synchronized (weakHashMap) {
                    if (SELF_CONTEXT_ACCESS_CLASS_LOADER == null) {
                        SELF_CONTEXT_ACCESS_CLASS_LOADER = new AccessClassLoader(SELF_CONTEXT_PARENT_CLASS_LOADER);
                    }
                }
            }
            return SELF_CONTEXT_ACCESS_CLASS_LOADER;
        }
        WeakHashMap<ClassLoader, WeakReference<AccessClassLoader>> weakHashMap = ACCESS_CLASS_LOADERS;
        synchronized (weakHashMap) {
            AccessClassLoader accessClassLoader;
            WeakReference<AccessClassLoader> ref = ACCESS_CLASS_LOADERS.get(parent);
            if (ref != null) {
                accessClassLoader = (AccessClassLoader)ref.get();
                if (accessClassLoader != null) {
                    return accessClassLoader;
                }
                ACCESS_CLASS_LOADERS.remove(parent);
            }
            accessClassLoader = new AccessClassLoader(parent);
            ACCESS_CLASS_LOADERS.put(parent, new WeakReference<AccessClassLoader>(accessClassLoader));
            return accessClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ClassLoader parent) {
        if (SELF_CONTEXT_PARENT_CLASS_LOADER.equals(parent)) {
            SELF_CONTEXT_ACCESS_CLASS_LOADER = null;
        } else {
            WeakHashMap<ClassLoader, WeakReference<AccessClassLoader>> weakHashMap = ACCESS_CLASS_LOADERS;
            synchronized (weakHashMap) {
                ACCESS_CLASS_LOADERS.remove(parent);
            }
        }
    }

    public static int activeAccessClassLoaders() {
        int sz = ACCESS_CLASS_LOADERS.size();
        if (SELF_CONTEXT_ACCESS_CLASS_LOADER != null) {
            ++sz;
        }
        return sz;
    }

    private AccessClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.equals(MethodAccess.class.getName())) {
            return MethodAccess.class;
        }
        return super.loadClass(name, resolve);
    }

    Class<?> defineClass(String name, byte[] bytes) throws ClassFormatError {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (Class)method.invoke((Object)this.getParent(), name, bytes, 0, bytes.length, this.getClass().getProtectionDomain());
        }
        catch (Exception exception) {
            return this.defineClass(name, bytes, 0, bytes.length, this.getClass().getProtectionDomain());
        }
    }

    private static ClassLoader getParentClassLoader(Class<?> type) {
        ClassLoader parent = type.getClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }
}

