/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.benchmark;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import xyz.noark.benchmark.BenchmarkCallback;
import xyz.noark.benchmark.BenchmarkThreadFactory;
import xyz.noark.log.LogHelper;

public class Benchmark {
    private final int runTimes;
    private final int warmupTimes;

    public Benchmark() {
        this(1000000);
    }

    public Benchmark(int runTimes) {
        this.warmupTimes = 10000;
        this.runTimes = runTimes;
    }

    public Benchmark(int warmupTimes, int runTimes) {
        this.warmupTimes = warmupTimes;
        this.runTimes = runTimes;
        LogHelper.logger.debug("Benchmark init warmupTimes={},runTimes={}", new Object[]{warmupTimes, runTimes});
    }

    public void doSomething(String name, BenchmarkCallback callback) throws Exception {
        this.doSomething(this.runTimes, name, callback);
    }

    public void doSomething(int times, String name, BenchmarkCallback callback) throws Exception {
        this.doSomething(1, times, name, callback);
    }

    public void doSomething(int thread, int times, String name, BenchmarkCallback callback) throws Exception {
        ExecutorService pool = Executors.newFixedThreadPool(thread, new BenchmarkThreadFactory(name));
        for (int i = 0; i < this.warmupTimes; ++i) {
            callback.doSomething();
        }
        CountDownLatch latch = new CountDownLatch(times);
        Instant startTime = Instant.now();
        if (thread == 1) {
            for (int i = 0; i < times; ++i) {
                callback.doSomething();
            }
        } else {
            for (int i = 0; i < times; ++i) {
                pool.execute(() -> {
                    try {
                        callback.doSomething();
                        latch.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                LogHelper.logger.error(e.getMessage(), new Object[]{e});
            }
        }
        Instant endTime = Instant.now();
        long interval = Duration.between(startTime, endTime).toMillis();
        LogHelper.logger.debug("{},{} - total= {} ms,times={}, speed= {} ms", new Object[]{Thread.currentThread().getName(), name, interval, times, String.format("%.6f", (double)interval * 1.0 / (double)times)});
    }
}

