/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.benchmark;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class BenchmarkThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final String name;
    private final ThreadGroup group;

    public BenchmarkThreadFactory(String name) {
        SecurityManager securitymanager = System.getSecurityManager();
        this.group = securitymanager == null ? Thread.currentThread().getThreadGroup() : securitymanager.getThreadGroup();
        this.name = name;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        StringBuilder threadName = new StringBuilder(this.name);
        threadName.append("-").append(this.threadCounter.getAndIncrement());
        Thread thread = new Thread(this.group, runnable, threadName.toString());
        return thread;
    }
}

