/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import xyz.noark.core.annotation.Component;
import xyz.noark.core.annotation.Configuration;
import xyz.noark.core.annotation.Controller;
import xyz.noark.core.annotation.Repository;
import xyz.noark.core.annotation.Service;
import xyz.noark.core.annotation.StaticComponent;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.ioc.BeanDefinition;
import xyz.noark.core.ioc.definition.ComponentBeanDefinition;
import xyz.noark.core.ioc.definition.ConfigurationBeanDefinition;
import xyz.noark.core.ioc.definition.ControllerBeanDefinition;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.ioc.definition.StaticComponentBeanDefinition;
import xyz.noark.core.ioc.scan.Resource;
import xyz.noark.core.ioc.scan.ResourceScanning;
import xyz.noark.core.util.ClassUtils;

public class IocLoader {
    private static final String PACKAGE_INFO_CLASS = "package-info.class";
    private static final String CLASS_SUFFIX = ".class";
    private final HashMap<Class<?>, DefaultBeanDefinition> beans = new HashMap(1024);
    private final List<BeanDefinition> configurations = new ArrayList<BeanDefinition>();
    private final List<StaticComponentBeanDefinition> staticcomponents = new ArrayList<StaticComponentBeanDefinition>();

    IocLoader(String ... packages) {
        ResourceScanning.scanPackage(packages, resource -> this.analysisResource(resource));
    }

    protected List<DefaultBeanDefinition> findImpl(Class<?> klass) {
        return this.beans.values().stream().filter(v -> klass.isInstance(v.getSingle())).collect(Collectors.toList());
    }

    private void analysisResource(Resource resource) {
        String resourceName = resource.getName();
        if (PACKAGE_INFO_CLASS.equals(resourceName)) {
            return;
        }
        if (!resourceName.endsWith(CLASS_SUFFIX)) {
            return;
        }
        this.analysisClass(ClassUtils.loadClass(resourceName.substring(0, resourceName.length() - 6).replaceAll("[/\\\\]", ".")));
    }

    private void analysisClass(Class<?> klass) {
        if (klass.isInterface() || klass.isMemberClass() || klass.isEnum() || klass.isAnnotation() || klass.isAnonymousClass()) {
            return;
        }
        int modify = klass.getModifiers();
        if (Modifier.isAbstract(modify) || !Modifier.isPublic(modify)) {
            return;
        }
        for (Annotation annotation : klass.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType == Configuration.class) {
                this.analytical(klass, (Configuration)Configuration.class.cast(annotation));
                continue;
            }
            if (annotationType == TemplateConverter.class) {
                this.analytical(klass, (TemplateConverter)TemplateConverter.class.cast(annotation));
                continue;
            }
            if (annotationType == Controller.class) {
                this.analytical(klass, (Controller)Controller.class.cast(annotation));
                continue;
            }
            if (annotationType == Service.class) {
                this.analytical(klass, (Service)Service.class.cast(annotation));
                continue;
            }
            if (annotationType == Repository.class) {
                this.analytical(klass, (Repository)Repository.class.cast(annotation));
                continue;
            }
            if (annotationType == StaticComponent.class) {
                this.analytical(klass, (StaticComponent)StaticComponent.class.cast(annotation));
                continue;
            }
            if (annotationType != Component.class) continue;
            this.analytical(klass, (Component)Component.class.cast(annotation));
        }
    }

    private void analytical(Class<?> klass, StaticComponent component) {
        this.staticcomponents.add(new StaticComponentBeanDefinition(klass).init());
    }

    private void analytical(Class<?> klass, Component component) {
        this.beans.put(klass, new ComponentBeanDefinition(klass, component).init());
    }

    private void analytical(Class<?> klass, Repository cast) {
        this.beans.put(klass, new DefaultBeanDefinition(klass).init());
    }

    private void analytical(Class<?> klass, Service cast) {
        this.beans.put(klass, new DefaultBeanDefinition(klass).init());
    }

    private void analytical(Class<?> klass, Controller controller) {
        this.beans.put(klass, new ControllerBeanDefinition(klass, controller).init());
    }

    private void analytical(Class<?> klass, TemplateConverter converter) {
        ConvertManager.getInstance().regist(klass, converter);
    }

    private void analytical(Class<?> klass, Configuration configuration) {
        this.configurations.add(new ConfigurationBeanDefinition(klass).init());
    }

    public HashMap<Class<?>, DefaultBeanDefinition> getBeans() {
        return this.beans;
    }

    public List<BeanDefinition> getConfigurations() {
        return this.configurations;
    }

    public List<StaticComponentBeanDefinition> getStaticComponents() {
        return this.staticcomponents;
    }
}

