/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Order;
import xyz.noark.core.annotation.Value;
import xyz.noark.core.ioc.BeanDefinition;
import xyz.noark.core.ioc.FieldDefinition;
import xyz.noark.core.ioc.IocMaking;
import xyz.noark.core.ioc.MethodDefinition;
import xyz.noark.core.ioc.NoarkIoc;
import xyz.noark.core.ioc.definition.field.DefaultFieldDefinition;
import xyz.noark.core.ioc.definition.field.ListFieldDefinition;
import xyz.noark.core.ioc.definition.field.MapFieldDefinition;
import xyz.noark.core.ioc.definition.field.ValueFieldDefinition;
import xyz.noark.core.ioc.definition.method.SimpleMethodDefinition;
import xyz.noark.core.ioc.wrap.method.BaseMethodWrapper;
import xyz.noark.core.util.ClassUtils;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.MethodUtils;
import xyz.noark.reflectasm.MethodAccess;

public class DefaultBeanDefinition
implements BeanDefinition {
    private static final Set<Class<?>> IGNORE_ANNOTATION_BY_METHODS = new HashSet();
    protected final Object single;
    private final Class<?> beanClass;
    private final int order;
    protected final MethodAccess methodAccess;
    private final ArrayList<FieldDefinition> autowiredFields = new ArrayList();
    protected final HashMap<Class<? extends Annotation>, List<MethodDefinition>> customMethods = new HashMap();

    public DefaultBeanDefinition(Class<?> klass) {
        this(ClassUtils.newInstance(klass));
    }

    public DefaultBeanDefinition(Object object) {
        this.single = object;
        this.beanClass = object.getClass();
        this.methodAccess = MethodAccess.get(this.beanClass);
        Order order = this.beanClass.getAnnotation(Order.class);
        this.order = order == null ? Integer.MAX_VALUE : order.value();
    }

    public DefaultBeanDefinition init() {
        this.analysisField();
        this.analysisMethod();
        return this;
    }

    @Override
    public String[] getNames() {
        return new String[]{this.beanClass.getName()};
    }

    public Object getSingle() {
        return this.single;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public int getOrder() {
        return this.order;
    }

    private void analysisMethod() {
        MethodUtils.getAllMethod(this.beanClass).forEach(method -> {
            Annotation[] annotations = method.getAnnotations();
            if (annotations != null && annotations.length > 0) {
                for (Annotation annotation : annotations) {
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    if (IGNORE_ANNOTATION_BY_METHODS.contains(annotationType)) continue;
                    this.analysisMthodByAnnotation(annotationType, annotation, (Method)method);
                }
            }
        });
    }

    protected void analysisMthodByAnnotation(Class<? extends Annotation> annotationType, Annotation annotation, Method method) {
        this.customMethods.computeIfAbsent(annotationType, key -> new ArrayList(64)).add(new SimpleMethodDefinition(this.methodAccess, method));
    }

    private void analysisField() {
        FieldUtils.getAllField(this.beanClass).stream().filter(v -> v.isAnnotationPresent(Autowired.class) || v.isAnnotationPresent(Value.class)).forEach(v -> this.analysisAutowiredOrValue((Field)v));
    }

    private void analysisAutowiredOrValue(Field field) {
        Class<?> fieldClass = field.getType();
        Value value = field.getAnnotation(Value.class);
        if (value == null) {
            Autowired autowired = field.getAnnotation(Autowired.class);
            if (fieldClass == List.class) {
                this.autowiredFields.add(new ListFieldDefinition(field, autowired.required()));
            } else if (fieldClass == Map.class) {
                this.autowiredFields.add(new MapFieldDefinition(field, autowired.required()));
            } else {
                this.autowiredFields.add(new DefaultFieldDefinition(field, autowired.required()));
            }
        } else {
            this.autowiredFields.add(new ValueFieldDefinition(field, value.value()));
        }
    }

    @Override
    public void injection(IocMaking making) {
        this.autowiredFields.forEach(v -> v.injection(this.single, making));
    }

    public void doAnalysisFunction(NoarkIoc ioc) {
        this.customMethods.forEach((k, list) -> list.forEach(v -> ioc.addCustomMethod((Class<? extends Annotation>)k, new BaseMethodWrapper(v.getMethodAccess(), this.single, v.getMethodIndex(), v.getOrder()))));
    }

    static {
        IGNORE_ANNOTATION_BY_METHODS.add(Override.class);
        IGNORE_ANNOTATION_BY_METHODS.add(Deprecated.class);
        IGNORE_ANNOTATION_BY_METHODS.add(SuppressWarnings.class);
    }
}

