/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.noark.core.event.Event;
import xyz.noark.core.ioc.wrap.method.EventMethodWrapper;

public class EventMethodManager {
    private final Map<Class<? extends Event>, List<EventMethodWrapper>> handlers = new ConcurrentHashMap<Class<? extends Event>, List<EventMethodWrapper>>();
    private static final EventMethodManager INSTANCE = new EventMethodManager();

    private EventMethodManager() {
    }

    public static EventMethodManager getInstance() {
        return INSTANCE;
    }

    public List<EventMethodWrapper> getEventMethodWrappers(Class<? extends Event> eventClass) {
        return this.handlers.getOrDefault(eventClass, Collections.emptyList());
    }

    public void resetEventHander(EventMethodWrapper eventWrapper) {
        this.handlers.computeIfAbsent(eventWrapper.getEventClass(), key -> new ArrayList()).add(eventWrapper);
    }

    public void sort() {
        this.handlers.values().forEach(v -> v.sort((h1, h2) -> h1.getOrder() - h2.getOrder()));
    }
}

