/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.manager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.wrap.method.PacketMethodWrapper;
import xyz.noark.log.LogHelper;

public class PacketMethodManager {
    private final ConcurrentMap<Integer, PacketMethodWrapper> handlers = new ConcurrentHashMap<Integer, PacketMethodWrapper>(2048);
    private static final PacketMethodManager INSTANCE = new PacketMethodManager();

    private PacketMethodManager() {
    }

    public static PacketMethodManager getInstance() {
        return INSTANCE;
    }

    public void resetPacketHandler(PacketMethodWrapper handler) {
        if (this.handlers.containsKey(handler.getOpcode())) {
            throw new ServerBootstrapException("\u91cd\u590d\u5b9a\u4e49\u7684 Opcode\uff1a" + handler.getOpcode());
        }
        this.handlers.put(handler.getOpcode(), handler);
    }

    public PacketMethodWrapper getPacketMethodWrapper(Integer opcode) {
        return (PacketMethodWrapper)this.handlers.get(opcode);
    }

    public boolean temporarilyClosed(Integer opcode) {
        PacketMethodWrapper method = this.getPacketMethodWrapper(opcode);
        if (method == null) {
            return false;
        }
        method.setDeprecated(true);
        return true;
    }

    public boolean temporaryOpening(Integer opcode) {
        PacketMethodWrapper method = this.getPacketMethodWrapper(opcode);
        if (method == null) {
            return false;
        }
        method.setDeprecated(false);
        return true;
    }

    public void outputStatInfo() {
        for (Map.Entry e : this.handlers.entrySet()) {
            long num = ((PacketMethodWrapper)e.getValue()).getCallNum();
            if (num <= 0L) continue;
            LogHelper.logger.info("protocal stat. opcode={}, call={}", new Object[]{e.getKey(), num});
        }
    }
}

