/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.wrap.method;

import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import xyz.noark.core.annotation.Controller;
import xyz.noark.core.annotation.controller.RequestParam;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.ioc.definition.method.HttpMethodDefinition;
import xyz.noark.core.ioc.wrap.method.AbstractControllerMethodWrapper;
import xyz.noark.core.ioc.wrap.param.HttpParamWrapper;
import xyz.noark.reflectasm.MethodAccess;

public class HttpMethodWrapper
extends AbstractControllerMethodWrapper {
    private final String uri;
    private final ArrayList<HttpParamWrapper> parameters = new ArrayList();
    private boolean deprecated = false;

    public HttpMethodWrapper(MethodAccess methodAccess, Object single, HttpMethodDefinition method, Controller controller) {
        super(methodAccess, single, method.getMethodIndex(), controller, method.getOrder(), "http(" + method.uri() + ")");
        this.uri = method.uri();
        this.deprecated = method.isDeprecated();
        Arrays.stream(method.getParameters()).forEach(v -> this.buildParamWrapper((Parameter)v));
    }

    private void buildParamWrapper(Parameter parameter) {
        RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
        if (requestParam == null) {
            throw new UnrealizedException("HTTP\u63a5\u53e3\u53c2\u6570\u6ca1\u6709\u672a\u6807\u8bc6@RequestParam. uri=" + this.uri);
        }
        this.parameters.add(new HttpParamWrapper(requestParam, parameter));
    }

    public String getUri() {
        return this.uri;
    }

    public ArrayList<HttpParamWrapper> getParameters() {
        return this.parameters;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }
}

