/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Optional;

public class FileUtils {
    private static final String[] UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "EB"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> getFileText(String name) {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);){
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            Optional<String> optional = Optional.of(new String(bytes));
            return optional;
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static String readableFileSize(File file) {
        return FileUtils.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + UNITS[digitGroups];
    }
}

