/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import xyz.noark.core.exception.HttpAccessException;
import xyz.noark.log.LogHelper;

public class HttpUtils {
    public static String get(String url) {
        LogHelper.logger.info("GET: url={}", new Object[]{url});
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.connect();
            StringBuilder sb = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                }
            }
            String result = sb.toString();
            LogHelper.logger.info(result);
            return result;
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }

    public static String post(String url, String params) {
        LogHelper.logger.info("POST: url={}, param={}", new Object[]{url, params});
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Charset", "UTF-8");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (!params.isEmpty()) {
                try (PrintWriter out = new PrintWriter(connection.getOutputStream());){
                    out.print(params);
                    out.flush();
                }
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                }
            }
            String result = sb.toString();
            LogHelper.logger.info(result);
            return result;
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }
}

