/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtils {
    public static boolean nextBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static int nextInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static int nextInt(int origin, int bound) {
        return ThreadLocalRandom.current().nextInt(origin, bound);
    }

    public static boolean isSuccess(float rate) {
        return ThreadLocalRandom.current().nextFloat() < rate;
    }

    public static <T> T randomList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(RandomUtils.nextInt(list.size()));
    }

    public static <T> List<T> randomList(List<T> source, int num) {
        if (source == null || num < 1) {
            return Collections.emptyList();
        }
        if (source.size() <= num) {
            ArrayList<T> result = new ArrayList<T>(source);
            Collections.shuffle(source);
            return result;
        }
        Object[] rs = source.toArray();
        ArrayList<Object> result = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            int index = RandomUtils.nextInt(rs.length - i);
            result.add(rs[index]);
            rs[index] = rs[rs.length - 1 - i];
        }
        return result;
    }

    public static <K> K randomByWeight(Map<K, Integer> data) {
        int random = RandomUtils.nextInt(data.values().stream().reduce(0, (a, b) -> a + b));
        int step = 0;
        for (Map.Entry<K, Integer> e : data.entrySet()) {
            if ((step += e.getValue().intValue()) <= random) continue;
            return e.getKey();
        }
        throw new RuntimeException("randomByWeight\u7684\u5b9e\u73b0\u6709Bug\uff1a" + random);
    }
}

