/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import xyz.noark.core.util.StringUtils;
import xyz.noark.core.util.SystemUtils;

public class SvnUtils {
    public static String up(String path) throws Exception {
        return SvnUtils.up(path, null, null);
    }

    public static String up(String path, String username, String password) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        sb.append("svn up ").append(path);
        return SvnUtils.exec(sb.toString(), username, password);
    }

    public static String checkout(String url, String path) throws Exception {
        return SvnUtils.checkout(url, path, null, null);
    }

    public static String checkout(String url, String path, String username, String password) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        sb.append("svn co ").append(url).append(" ").append(path);
        return SvnUtils.exec(sb.toString(), username, password);
    }

    private static String exec(String cmd, String username, String password) throws Exception {
        StringBuilder sb = new StringBuilder(256);
        sb.append(cmd);
        if (StringUtils.isNotEmpty(username)) {
            sb.append(" --username ").append(username);
        }
        if (StringUtils.isNotEmpty(password)) {
            sb.append(" --password ").append(password);
        }
        ArrayList<String> envp = new ArrayList<String>(4);
        if (SystemUtils.IS_OS_LINUX) {
            envp.addAll(Arrays.asList("sh", "-c", sb.toString()));
        } else {
            envp.addAll(Arrays.asList(sb.toString()));
        }
        envp.add("LANG=UTF-8");
        Process process = Runtime.getRuntime().exec(envp.toArray(new String[0]));
        try (InputStreamReader isr = new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8"));
             LineNumberReader in = new LineNumberReader(isr);){
            String tmp = "";
            sb.setLength(0);
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp).append("\n");
            }
        }
        return sb.toString();
    }
}

