/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import xyz.noark.core.annotation.Controller;
import xyz.noark.core.annotation.ModuleController;
import xyz.noark.core.annotation.controller.EventListener;
import xyz.noark.core.annotation.controller.ExecThreadGroup;
import xyz.noark.core.annotation.controller.HttpHandler;
import xyz.noark.core.annotation.controller.PacketMapping;
import xyz.noark.core.ioc.NoarkIoc;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.ioc.definition.method.EventMethodDefinition;
import xyz.noark.core.ioc.definition.method.HttpMethodDefinition;
import xyz.noark.core.ioc.definition.method.PacketMethodDefinition;
import xyz.noark.core.ioc.manager.EventMethodManager;
import xyz.noark.core.ioc.manager.HttpMethodManager;
import xyz.noark.core.ioc.manager.PacketMethodManager;
import xyz.noark.core.ioc.wrap.method.EventMethodWrapper;
import xyz.noark.core.ioc.wrap.method.HttpMethodWrapper;
import xyz.noark.core.ioc.wrap.method.PacketMethodWrapper;

public class ControllerBeanDefinition
extends DefaultBeanDefinition {
    private final ExecThreadGroup threadGroup;
    private final Class<?> controllerMasterClass;
    private final ArrayList<PacketMethodDefinition> pmds = new ArrayList();
    private final ArrayList<EventMethodDefinition> emds = new ArrayList();
    private final ArrayList<HttpMethodDefinition> hmds = new ArrayList();

    public ControllerBeanDefinition(Class<?> klass, Controller controller) {
        this(klass, controller.threadGroup(), klass);
    }

    public ControllerBeanDefinition(Class<?> klass, ModuleController controller) {
        this(klass, ExecThreadGroup.ModuleThreadGroup, controller.master());
    }

    private ControllerBeanDefinition(Class<?> klass, ExecThreadGroup threadGroup, Class<?> controllerMasterClass) {
        super(klass);
        this.threadGroup = threadGroup;
        this.controllerMasterClass = klass;
    }

    @Override
    protected void analysisMthodByAnnotation(Class<? extends Annotation> annotationType, Annotation annotation, Method method) {
        if (annotationType == PacketMapping.class) {
            this.pmds.add(new PacketMethodDefinition(this.methodAccess, method, (PacketMapping)PacketMapping.class.cast(annotation)));
        } else if (annotationType == EventListener.class) {
            this.emds.add(new EventMethodDefinition(this.methodAccess, method, (EventListener)EventListener.class.cast(annotation), this));
        } else if (annotationType == HttpHandler.class) {
            this.hmds.add(new HttpMethodDefinition(this.methodAccess, method, (HttpHandler)HttpHandler.class.cast(annotation)));
        } else {
            super.analysisMthodByAnnotation(annotationType, annotation, method);
        }
    }

    @Override
    public void doAnalysisFunction(NoarkIoc noarkIoc) {
        super.doAnalysisFunction(noarkIoc);
        this.doAnalysisPacketHandler(noarkIoc);
        this.doAnalysisEventHandler(noarkIoc);
        this.doAnalysisHttpHandler(noarkIoc);
    }

    private void doAnalysisHttpHandler(NoarkIoc noarkIoc) {
        HttpMethodManager manager = HttpMethodManager.getInstance();
        this.hmds.forEach(hmd -> manager.resetHttpHandler(new HttpMethodWrapper(this.methodAccess, this.single, (HttpMethodDefinition)hmd, this.threadGroup, this.controllerMasterClass)));
    }

    private void doAnalysisEventHandler(NoarkIoc ioc) {
        EventMethodManager manager = EventMethodManager.getInstance();
        this.emds.forEach(emd -> manager.resetEventHander(new EventMethodWrapper(this.methodAccess, this.single, (EventMethodDefinition)emd, this.threadGroup, this.controllerMasterClass)));
    }

    private void doAnalysisPacketHandler(NoarkIoc noarkIoc) {
        PacketMethodManager manager = PacketMethodManager.getInstance();
        this.pmds.forEach(pmd -> manager.resetPacketHandler(new PacketMethodWrapper(this.methodAccess, this.single, (PacketMethodDefinition)pmd, this.threadGroup, this.controllerMasterClass)));
    }
}

