/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition.field;

import java.lang.reflect.Field;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.env.EnvConfigHolder;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.ioc.IocMaking;
import xyz.noark.core.ioc.definition.field.DefaultFieldDefinition;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.core.util.StringUtils;

public class ValueFieldDefinition
extends DefaultFieldDefinition {
    private final String key;

    public ValueFieldDefinition(Field field, String key) {
        super(field, false);
        this.key = key;
    }

    @Override
    public void injection(Object single, IocMaking making) {
        String value = EnvConfigHolder.getProperties().get(this.key);
        if (StringUtils.isNotEmpty(value)) {
            Converter<?> converter = ConvertManager.getInstance().getConverter(this.field.getType());
            if (converter != null) {
                try {
                    FieldUtils.writeField(single, this.field, converter.convert(this.field, value));
                }
                catch (Exception e) {
                    throw new ConvertException(single.getClass().getName() + " >> " + this.field.getName() + " >> " + value + "-->" + converter.buildErrorMsg(), e);
                }
            } else {
                throw new UnrealizedException("\u7c7b\uff1a" + single.getClass().getName() + "\u4e2d\u7684\u5c5e\u6027\uff1a" + this.field.getName() + "\u7c7b\u578b\u672a\u5b9e\u73b0\u6b64\u8f6c\u5316\u5668");
            }
        }
    }
}

