/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.scan;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.scan.FileResource;
import xyz.noark.core.ioc.scan.JarResource;
import xyz.noark.core.ioc.scan.ResourceCallback;
import xyz.noark.log.LogHelper;

public class ResourceScanning {
    private static final String URL_PROTOCOL_FILE = "file";
    private static final String URL_PROTOCOL_JAR = "jar";
    private static final String BACKSLASH = "/";

    private ResourceScanning() {
    }

    public static void scanPackage(String[] packages, ResourceCallback callback) {
        for (String packagePath : packages) {
            ResourceScanning.scanPackage(packagePath, callback);
        }
    }

    private static void scanPackage(String packagePath, ResourceCallback callback) {
        if (!(packagePath = packagePath.replace('.', '/').replace('\\', '/')).endsWith(BACKSLASH)) {
            packagePath = packagePath + BACKSLASH;
        }
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(packagePath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                switch (url.getProtocol()) {
                    case "file": {
                        ResourceScanning.doFindFileResources(packagePath, new File(url.getFile()), callback);
                        break;
                    }
                    case "jar": {
                        ResourceScanning.doFindJarResources(url, callback, packagePath);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ServerBootstrapException("\u626b\u63cf\u8fc7\u7a0b\u4e2d\u51fa\u5f02\u5e38\u5566", e);
        }
    }

    private static void doFindJarResources(URL url, ResourceCallback callback, String rootEntryPath) throws IOException {
        JarURLConnection jarCon = (JarURLConnection)url.openConnection();
        try (JarFile jarFile = jarCon.getJarFile();){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String entryPath = entries.nextElement().getName();
                if (!entryPath.startsWith(rootEntryPath)) continue;
                ResourceScanning.findJarFile(entryPath, callback);
            }
        }
    }

    private static void doFindFileResources(String packagePath, File file, ResourceCallback callback) {
        String path = file.getAbsolutePath();
        if (!file.exists()) {
            LogHelper.logger.debug("Skipping [{}] because it does not exist", new Object[]{path});
            return;
        }
        if (!file.canRead()) {
            LogHelper.logger.warn("Cannot search for matching files underneath directory [{}] because the application is not allowed to read the directory", new Object[]{path});
            return;
        }
        if (file.isDirectory()) {
            ResourceScanning.findDir(packagePath, file, callback);
        } else if (file.isFile()) {
            ResourceScanning.findFile(packagePath, file, callback);
        }
    }

    private static void findDir(String packagePath, File dir, ResourceCallback callback) {
        File[] dirContents = dir.listFiles();
        if (dirContents == null) {
            LogHelper.logger.warn("Could not retrieve contents of directory [{}]", new Object[]{dir.getAbsolutePath()});
            return;
        }
        for (File content : dirContents) {
            if (content.isFile()) {
                ResourceScanning.findFile(packagePath, content, callback);
                continue;
            }
            if (!content.isDirectory()) continue;
            ResourceScanning.findDir(packagePath + content.getName() + BACKSLASH, content, callback);
        }
    }

    private static void findJarFile(String entryPath, ResourceCallback callback) {
        callback.handle(new JarResource(entryPath));
    }

    private static void findFile(String packagePath, File file, ResourceCallback callback) {
        callback.handle(new FileResource(packagePath, file));
    }
}

