/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.wrap.method;

import java.io.Serializable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.LongAdder;
import xyz.noark.core.annotation.PlayerId;
import xyz.noark.core.annotation.controller.ExecThreadGroup;
import xyz.noark.core.ioc.definition.method.PacketMethodDefinition;
import xyz.noark.core.ioc.wrap.ParamWrapper;
import xyz.noark.core.ioc.wrap.method.AbstractControllerMethodWrapper;
import xyz.noark.core.ioc.wrap.param.ByteArrayParamWrapper;
import xyz.noark.core.ioc.wrap.param.PacketParamWrapper;
import xyz.noark.core.ioc.wrap.param.PlayerIdParamWrapper;
import xyz.noark.core.ioc.wrap.param.SessionParamWrapper;
import xyz.noark.core.lang.ByteArray;
import xyz.noark.core.network.Session;
import xyz.noark.reflectasm.MethodAccess;

public class PacketMethodWrapper
extends AbstractControllerMethodWrapper {
    private final Integer opcode;
    private final boolean inner;
    private final Session.State state;
    private final ArrayList<ParamWrapper> parameters;
    private final LongAdder callNum = new LongAdder();
    private boolean deprecated = false;

    public PacketMethodWrapper(MethodAccess methodAccess, Object single, PacketMethodDefinition md, ExecThreadGroup threadGroup, Class<?> controllerMasterClass) {
        super(methodAccess, single, md.getMethodIndex(), threadGroup, controllerMasterClass.getName(), md.getOrder(), "protocal(opcode=" + md.getOpcode() + ")");
        this.state = md.getState();
        this.opcode = md.getOpcode();
        this.inner = md.isInnerPacket();
        this.printLog = md.isPrintLog();
        this.deprecated = md.isDeprecated();
        this.parameters = new ArrayList(md.getParameters().length);
        Arrays.stream(md.getParameters()).forEach(v -> this.buildParamWrapper((Parameter)v));
    }

    private void buildParamWrapper(Parameter parameter) {
        if (Session.class.isAssignableFrom(parameter.getType())) {
            this.parameters.add(new SessionParamWrapper());
        } else if (parameter.isAnnotationPresent(PlayerId.class)) {
            this.parameters.add(new PlayerIdParamWrapper());
        } else if (parameter.getType().equals(byte[].class)) {
            this.parameters.add(new ByteArrayParamWrapper());
        } else {
            this.parameters.add(new PacketParamWrapper(parameter.getType()));
        }
    }

    public Object[] analysisParam(Session session, ByteArray bytes) {
        ArrayList<Object> args = new ArrayList<Object>(this.parameters.size());
        for (ParamWrapper parameter : this.parameters) {
            args.add(parameter.read(session, bytes));
        }
        return args.toArray();
    }

    public Object[] analysisParam(Serializable playerId, Object protocal) {
        ArrayList<Object> args = new ArrayList<Object>(this.parameters.size());
        for (ParamWrapper parameter : this.parameters) {
            args.add(parameter.read(playerId, protocal));
        }
        return args.toArray();
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Integer getOpcode() {
        return this.opcode;
    }

    public boolean isInner() {
        return this.inner;
    }

    public Session.State getState() {
        return this.state;
    }

    public void incrCallNum() {
        this.callNum.increment();
    }

    public long getCallNum() {
        return this.callNum.longValue();
    }
}

