/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.util.Arrays;
import java.util.RandomAccess;
import java.util.concurrent.ThreadLocalRandom;
import xyz.noark.core.lang.DoubleList;

public class DoubleArrayList
implements DoubleList,
RandomAccess {
    private static final int DEFAULT_CAPACITY = 10;
    private static final double[] EMPTY_ELEMENTDATA = new double[0];
    private double[] elementData;
    private int size = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public DoubleArrayList() {
        this.elementData = EMPTY_ELEMENTDATA;
    }

    public DoubleArrayList(int initialCapacity) {
        if (initialCapacity > 0) {
            this.elementData = new double[initialCapacity];
        } else if (initialCapacity == 0) {
            this.elementData = EMPTY_ELEMENTDATA;
        } else {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
    }

    public void trimToSize() {
        if (this.size < this.elementData.length) {
            this.elementData = this.size == 0 ? EMPTY_ELEMENTDATA : Arrays.copyOf(this.elementData, this.size);
        }
    }

    @Override
    public double random() {
        return this.elementData[ThreadLocalRandom.current().nextInt(0, this.size)];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(double o) {
        return this.indexOf(o) >= 0;
    }

    public int indexOf(double x) {
        for (int i = 0; i < this.size; ++i) {
            if (x != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double x) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (x != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public double get(int index) {
        this.rangeCheck(index);
        return this.elementData[index];
    }

    @Override
    public boolean add(double e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public boolean remove(double o) {
        for (int index = 0; index < this.size; ++index) {
            if (o != this.elementData[index]) continue;
            this.fastRemove(index);
            return true;
        }
        return false;
    }

    private void fastRemove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0.0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public boolean addAll(double[] a) {
        int numNew = a.length;
        this.ensureCapacityInternal(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size;
    }

    private void ensureCapacityInternal(int minCapacity) {
        if (this.elementData == EMPTY_ELEMENTDATA) {
            minCapacity = Math.max(10, minCapacity);
        }
        this.ensureExplicitCapacity(minCapacity);
    }

    private void ensureExplicitCapacity(int minCapacity) {
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = DoubleArrayList.hugeCapacity(minCapacity);
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.elementData);
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleArrayList other = (DoubleArrayList)obj;
        if (!Arrays.equals(this.elementData, other.elementData)) {
            return false;
        }
        return this.size == other.size;
    }
}

