/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import xyz.noark.core.lang.Pair;
import xyz.noark.core.lang.PairMap;

public class PairHashMap<L, R, V>
implements PairMap<L, R, V> {
    private final HashMap<Pair<L, R>, V> hashmap;

    public PairHashMap() {
        this.hashmap = new HashMap();
    }

    public PairHashMap(int initialCapacity) {
        this.hashmap = new HashMap(initialCapacity);
    }

    public PairHashMap(int initialCapacity, float loadFactor) {
        this.hashmap = new HashMap(initialCapacity, loadFactor);
    }

    public PairHashMap(List<V> templates, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends R> rightMapper) {
        this(templates.size() + 1, 1.0f);
        templates.forEach(v -> this.put((L)v, (R)leftMapper, (V)rightMapper));
    }

    @Override
    private V put(V value, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends R> rightMapper) {
        return this.put(leftMapper.apply(value), rightMapper.apply(value), value);
    }

    @Override
    public V put(L left, R right, V value) {
        return this.hashmap.put(Pair.of(left, right), value);
    }

    @Override
    public int size() {
        return this.hashmap.size();
    }

    @Override
    public V get(L left, R right) {
        return this.hashmap.get(Pair.of(left, right));
    }

    public String toString() {
        return "PairHashMap [data=" + this.hashmap + "]";
    }
}

