/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import xyz.noark.core.lang.Triple;
import xyz.noark.core.lang.TripleMap;

public class TripleHashMap<L, M, R, V>
implements TripleMap<L, M, R, V> {
    private final HashMap<Triple<L, M, R>, V> hashmap;

    public TripleHashMap() {
        this.hashmap = new HashMap();
    }

    public TripleHashMap(int initialCapacity) {
        this.hashmap = new HashMap(initialCapacity);
    }

    public TripleHashMap(int initialCapacity, float loadFactor) {
        this.hashmap = new HashMap(initialCapacity, loadFactor);
    }

    public TripleHashMap(List<V> templates, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends M> middleMapper, Function<? super V, ? extends R> rightMapper) {
        this(templates.size() + 1, 1.0f);
        templates.forEach(v -> this.put((L)v, (M)leftMapper, (R)middleMapper, (V)rightMapper));
    }

    @Override
    private V put(V value, Function<? super V, ? extends L> leftMapper, Function<? super V, ? extends M> middleMapper, Function<? super V, ? extends R> rightMapper) {
        return this.put(leftMapper.apply(value), middleMapper.apply(value), rightMapper.apply(value), value);
    }

    @Override
    public int size() {
        return this.hashmap.size();
    }

    @Override
    public V put(L left, M middle, R right, V value) {
        return this.hashmap.put(Triple.of(left, middle, right), value);
    }

    @Override
    public V get(L left, M middle, R right) {
        return this.hashmap.get(Triple.of(left, middle, right));
    }
}

