/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.annotation.Autowired;
import xyz.noark.core.annotation.Service;
import xyz.noark.core.event.Event;
import xyz.noark.core.event.PlayerEvent;
import xyz.noark.core.exception.UnrealizedException;
import xyz.noark.core.ioc.manager.PacketMethodManager;
import xyz.noark.core.ioc.wrap.method.EventMethodWrapper;
import xyz.noark.core.ioc.wrap.method.PacketMethodWrapper;
import xyz.noark.core.lang.TimeoutHashMap;
import xyz.noark.core.network.NetworkListener;
import xyz.noark.core.network.NetworkPacket;
import xyz.noark.core.network.ResultHelper;
import xyz.noark.core.network.Session;
import xyz.noark.core.thread.AsyncTask;
import xyz.noark.core.thread.NamedThreadFactory;
import xyz.noark.core.thread.TaskQueue;
import xyz.noark.core.thread.command.PlayerThreadCommand;
import xyz.noark.core.thread.command.SystemThreadCommand;
import xyz.noark.log.LogHelper;

@Service
public class ThreadDispatcher {
    private static final int SHUTDOWN_MAX_TIME = 10;
    private ExecutorService businessThreadPool;
    private TimeoutHashMap<Serializable, TaskQueue> businessThreadPoolTaskQueue;
    @Autowired(required=false)
    private NetworkListener networkListener;

    public void init(int poolSize, String threadNamePrefix, int timeout) {
        this.businessThreadPool = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadNamePrefix));
        this.businessThreadPoolTaskQueue = new TimeoutHashMap(timeout, TimeUnit.MINUTES, () -> new TaskQueue(this.businessThreadPool));
    }

    public void dispatchPacket(Session session, NetworkPacket packet) {
        PacketMethodWrapper pmw = PacketMethodManager.getInstance().getPacketMethodWrapper(packet.getOpcode());
        if (pmw == null) {
            LogHelper.logger.warn("undefined protocol, opcode={}", new Object[]{packet.getOpcode()});
            return;
        }
        if (pmw.isDeprecated()) {
            LogHelper.logger.warn("deprecated protocol. opcode={}, playerId={}", new Object[]{packet.getOpcode(), session.getPlayerId()});
            if (this.networkListener != null) {
                this.networkListener.handleDeprecatedPacket(session);
            }
            return;
        }
        if (pmw.isInner()) {
            LogHelper.logger.warn(" ^0^ inner protocol. opcode={}, playerId={}", new Object[]{packet.getOpcode(), session.getPlayerId()});
            return;
        }
        if (Session.State.ALL != pmw.getState() && pmw.getState() != session.getState()) {
            LogHelper.logger.warn(" ^0^ session state error. opcode={}, playerId={}", new Object[]{packet.getOpcode(), session.getPlayerId()});
            return;
        }
        pmw.incrCallNum();
        this.dispatchPacket(session, session.getPlayerId(), packet.getIncode(), pmw, pmw.analysisParam(session, packet.getByteArray()));
    }

    public void dispatchInnerPacket(Serializable playerId, Integer opcode, Object protocal) {
        PacketMethodWrapper pmw = PacketMethodManager.getInstance().getPacketMethodWrapper(opcode);
        if (pmw == null) {
            LogHelper.logger.warn("undefined protocol, opcode={}", new Object[]{opcode});
            return;
        }
        if (pmw.isDeprecated()) {
            LogHelper.logger.warn("deprecated protocol. opcode={}, playerId={}", new Object[]{opcode, playerId});
            return;
        }
        pmw.incrCallNum();
        this.dispatchPacket(null, playerId, 0, pmw, pmw.analysisParam(playerId, protocal));
    }

    private void dispatchPacket(Session session, Serializable playerId, int reqId, PacketMethodWrapper pmw, Object ... args) {
        switch (pmw.threadGroup()) {
            case NettyThreadGroup: {
                this.dispatchNettyThreadHandle(session, reqId, pmw, args);
                break;
            }
            case PlayerThreadGroup: {
                this.dispatchPlayerThreadHandle(session, reqId, new PlayerThreadCommand(playerId, pmw, args));
                break;
            }
            case ModuleThreadGroup: {
                this.dispatchSystemThreadHandle(session, reqId, new SystemThreadCommand(playerId, pmw.getModule(), pmw, args));
                break;
            }
            default: {
                throw new UnrealizedException("\u975e\u6cd5\u7ebf\u7a0b\u6267\u884c\u7ec4:" + (Object)((Object)pmw.threadGroup()));
            }
        }
    }

    void dispatchNettyThreadHandle(Session session, int reqId, PacketMethodWrapper protocal, Object ... args) {
        ResultHelper.trySendResult(session, reqId, protocal.invoke(args));
    }

    void dispatchSystemThreadHandle(Session session, int reqId, SystemThreadCommand command) {
        TaskQueue taskQueue = this.businessThreadPoolTaskQueue.get((Serializable)((Object)command.getModule()));
        taskQueue.submit(new AsyncTask(this.networkListener, taskQueue, command, command.getPlayerId(), reqId, session));
    }

    void dispatchPlayerThreadHandle(Session session, int reqId, PlayerThreadCommand command) {
        TaskQueue taskQueue = this.businessThreadPoolTaskQueue.get(command.getPlayerId());
        taskQueue.submit(new AsyncTask(this.networkListener, taskQueue, command, command.getPlayerId(), reqId, session));
    }

    public void dispatchEvent(EventMethodWrapper handler, Event event) {
        switch (handler.threadGroup()) {
            case PlayerThreadGroup: {
                if (event instanceof PlayerEvent) {
                    PlayerEvent e = (PlayerEvent)event;
                    this.dispatchPlayerThreadHandle(null, 0, new PlayerThreadCommand(e.getPlayerId(), handler, e));
                    break;
                }
                throw new UnrealizedException("\u73a9\u5bb6\u7ebf\u7a0b\u76d1\u542c\u7684\u4e8b\u4ef6\uff0c\u9700\u8981\u5b9e\u73b0PlayerEvent\u63a5\u53e3. event=" + event.getClass().getSimpleName());
            }
            case ModuleThreadGroup: {
                this.dispatchSystemThreadHandle(null, 0, new SystemThreadCommand(handler.getModule(), handler, event));
                break;
            }
            default: {
                throw new UnrealizedException("\u4e8b\u4ef6\u76d1\u542c\u53d1\u73b0\u4e86\u975e\u6cd5\u7ebf\u7a0b\u6267\u884c\u7ec4:" + (Object)((Object)handler.threadGroup()));
            }
        }
    }

    public void shutdown() {
        LogHelper.logger.info("\u5f00\u59cb\u901a\u77e5\u505c\u6b62\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7684\u7ebf\u7a0b\u6c60\u505c\u6b62\u670d\u52a1.");
        this.businessThreadPool.shutdown();
        try {
            if (!this.businessThreadPool.awaitTermination(10L, TimeUnit.MINUTES)) {
                this.businessThreadPool.shutdownNow();
            }
            LogHelper.logger.info("\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7684\u7ebf\u7a0b\u6c60\u5df2\u505c\u6b62\u670d\u52a1");
        }
        catch (InterruptedException ie) {
            LogHelper.logger.error("\u505c\u6b62\u5904\u7406\u4e1a\u52a1\u903b\u8f91\u7684\u7ebf\u7a0b\u6c60\u65f6\u53d1\u751f\u5f02\u5e38.", new Object[]{ie});
            this.businessThreadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

