/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import xyz.noark.core.lang.Point;

public class MathUtils {
    public static int addExact(int x, int y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static long addExact(long x, long y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    public static int multiplyExact(int x, int y) {
        try {
            return Math.multiplyExact(x, y);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static long multiplyExact(long x, long y) {
        try {
            return Math.multiplyExact(x, y);
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    public static double distance(int x1, int y1, int x2, int y2) {
        double x = Math.abs(x1 - x2);
        double y = Math.abs(y1 - y2);
        return Math.sqrt(x * x + y * y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double x = Math.abs(x1 - x2);
        double y = Math.abs(y1 - y2);
        return Math.sqrt(x * x + y * y);
    }

    public static double distance(Point p1, Point p2) {
        return MathUtils.distance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static boolean adjacent(int x1, int y1, int x2, int y2) {
        return Math.abs(x1 - x2) <= 1 && Math.abs(y1 - y2) <= 1;
    }

    public static boolean adjacent(Point p1, Point p2) {
        return MathUtils.adjacent(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static int floorInt(double a) {
        return (int)Math.floor(a);
    }

    public static long floorLong(double a) {
        return (long)Math.floor(a);
    }

    public static int ceilInt(double a) {
        return (int)Math.ceil(a);
    }

    public static long ceilLong(double a) {
        return (long)Math.ceil(a);
    }

    public static float formatScale(float value, int newScale) {
        return MathUtils.formatScale(value, newScale, RoundingMode.HALF_UP);
    }

    public static float formatScale(float value, int newScale, RoundingMode mode) {
        return new BigDecimal(value).setScale(newScale, mode).floatValue();
    }

    public static double formatScale(double value, int newScale) {
        return MathUtils.formatScale(value, newScale, RoundingMode.HALF_UP);
    }

    public static double formatScale(double value, int newScale, RoundingMode mode) {
        return new BigDecimal(value).setScale(newScale, mode).doubleValue();
    }
}

