/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import xyz.noark.core.util.ByteArrayUtils;
import xyz.noark.core.util.CharsetUtils;

public class StringUtils {
    public static final String EMPTY = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean isNotEmpty(String text) {
        return !StringUtils.isEmpty(text);
    }

    public static int length(String text) {
        if (text == null) {
            return 0;
        }
        int sum = 0;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            sum += text.charAt(i) > '\u007f' ? 2 : 1;
        }
        return sum;
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, false);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        boolean flag;
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        boolean bl = flag = preserveAllTokens && lastMatch;
        if (match || flag) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String lowerWord(CharSequence cs, char c) {
        int len = cs.length();
        StringBuilder sb = new StringBuilder(len + 5);
        for (int i = 0; i < len; ++i) {
            char ch = cs.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append(c);
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static int asciiSizeInBytes(long v) {
        if (v == 0L) {
            return 1;
        }
        if (v == Long.MIN_VALUE) {
            return 20;
        }
        boolean negative = false;
        if (v < 0L) {
            v = -v;
            negative = true;
        }
        int width = v < 100000000L ? (v < 10000L ? (v < 100L ? (v < 10L ? 1 : 2) : (v < 1000L ? 3 : 4)) : (v < 1000000L ? (v < 100000L ? 5 : 6) : (v < 10000000L ? 7 : 8))) : (v < 1000000000000L ? (v < 10000000000L ? (v < 1000000000L ? 9 : 10) : (v < 100000000000L ? 11 : 12)) : (v < 1000000000000000L ? (v < 10000000000000L ? 13 : (v < 10000000000000L ? 14 : 15)) : (v < 100000000000000000L ? (v < 10000000000000000L ? 16 : 17) : (v < 1000000000000000000L ? 18 : 19))));
        return negative ? width + 1 : width;
    }

    public static String join(String ... strings) {
        int len = 0;
        for (String str : strings) {
            len += str.length();
        }
        StringBuilder result = new StringBuilder(len);
        for (String str : strings) {
            result.append(str);
        }
        return result.toString();
    }

    public static String build(String delimiter, String prefix, String suffix, String ... strings) {
        int len = prefix.length() + suffix.length() + (strings.length - 1) * delimiter.length();
        for (String str : strings) {
            len += str.length();
        }
        StringBuilder result = new StringBuilder(len);
        result.append(prefix);
        for (String str : strings) {
            result.append(str).append(delimiter);
        }
        if (result.length() > prefix.length()) {
            result.deleteCharAt(result.length() - 1);
        }
        result.append(suffix);
        return result.toString();
    }

    public static byte[] utf8Bytes(CharSequence str) {
        return StringUtils.bytes(str, CharsetUtils.CHARSET_UTF_8);
    }

    public static byte[] bytes(CharSequence str) {
        return StringUtils.bytes(str, null);
    }

    public static byte[] bytes(CharSequence str, Charset charset) {
        if (str == null) {
            return ByteArrayUtils.EMPTY_BYTE_ARRAY;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }
}

