/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.AbstractConverter;
import xyz.noark.core.lang.IntArrayList;
import xyz.noark.core.lang.IntList;
import xyz.noark.core.util.StringUtils;

@TemplateConverter(value={IntList.class, IntArrayList.class})
public class IntListConverter
extends AbstractConverter<IntList> {
    @Override
    public IntList convert(String value) {
        if (StringUtils.isEmpty(value)) {
            return new IntArrayList();
        }
        String[] array = StringUtils.split(value, ",");
        IntArrayList result = new IntArrayList(array.length);
        Arrays.stream(array).forEach(v -> result.add(Integer.parseInt(v)));
        return result;
    }

    @Override
    public IntList convert(Field field, Map<String, String> data) {
        if (data.isEmpty()) {
            return new IntArrayList();
        }
        return new IntArrayList(data.values().stream().mapToInt(Integer::parseInt).toArray());
    }

    @Override
    public String buildErrorMsg() {
        return "\u6570\u5b57\u7c7b\u578b\u7684\u6570\u7ec4\u5e94\u8be5\u662f\u4ee5\u82f1\u6587\u9017\u53f7\u5206\u9694\u7684\uff0c\u5982\uff1a1,2,3,4";
    }
}

