/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import xyz.noark.core.event.Event;
import xyz.noark.core.ioc.wrap.method.EventMethodWrapper;

public class EventMethodManager {
    private final Map<Class<? extends Event>, List<EventMethodWrapper>> handlers = new ConcurrentHashMap<Class<? extends Event>, List<EventMethodWrapper>>();
    private final Set<Class<? extends Event>> rebuildSet = new HashSet<Class<? extends Event>>();
    private static final EventMethodManager INSTANCE = new EventMethodManager();

    private EventMethodManager() {
    }

    public static EventMethodManager getInstance() {
        return INSTANCE;
    }

    public List<EventMethodWrapper> getEventMethodWrappers(Class<? extends Event> eventClass) {
        return this.handlers.getOrDefault(eventClass, Collections.emptyList());
    }

    public void resetEventHandler(EventMethodWrapper eventWrapper) {
        this.handlers.computeIfAbsent(eventWrapper.getEventClass(), key -> new ArrayList()).add(eventWrapper);
    }

    public void sort() {
        this.handlers.values().forEach(v -> this.sort((List<EventMethodWrapper>)v));
    }

    private void sort(List<EventMethodWrapper> handlers) {
        Collections.sort(handlers);
    }

    public EventMethodManager listenerExtend() {
        HashMap<Class, Set> extend = new HashMap<Class, Set>(32);
        for (Class<? extends Event> klass : this.handlers.keySet()) {
            for (Map.Entry<Class<? extends Event>, List<EventMethodWrapper>> e : this.handlers.entrySet()) {
                if (klass.equals(e.getKey()) || !e.getKey().isAssignableFrom(klass)) continue;
                extend.computeIfAbsent(klass, key -> new HashSet()).addAll((Collection)e.getValue());
            }
        }
        extend.forEach((k, v) -> this.handlers.computeIfAbsent((Class<? extends Event>)k, key -> new ArrayList()).addAll(v));
        return INSTANCE;
    }

    public List<EventMethodWrapper> rebuildEventHandler(Class<? extends Event> klass) {
        List<EventMethodWrapper> result = this.getEventMethodWrappers(klass);
        if (!result.isEmpty() || this.rebuildSet.contains(klass)) {
            return result;
        }
        this.rebuildSet.add(klass);
        HashSet hs = new HashSet();
        for (Map.Entry<Class<? extends Event>, List<EventMethodWrapper>> e : this.handlers.entrySet()) {
            if (klass.equals(e.getKey()) || !e.getKey().isAssignableFrom(klass)) continue;
            hs.addAll(e.getValue());
        }
        result = new ArrayList<EventMethodWrapper>(hs);
        this.sort(result);
        this.handlers.put(klass, result);
        return result;
    }
}

