/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.io.OutputStream;
import xyz.noark.core.lang.ByteArray;

public class ByteArrayOutputStream
extends OutputStream {
    protected final ByteArray byteArray;
    private int writeIndex = 0;

    public ByteArrayOutputStream(ByteArray byteArray) {
        this.byteArray = byteArray;
    }

    @Override
    public void write(int value) {
        this.byteArray.setByte(this.writeIndex++, (byte)value);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        for (int i = off; i < len; ++i) {
            this.write(bytes[i]);
        }
    }

    public void writeByte(byte value) {
        this.write(value);
    }

    public void writeShort(int value) {
        this.writeByte((byte)(value >> 8));
        this.writeByte((byte)value);
    }

    public void writeShortLE(int value) {
        this.writeByte((byte)value);
        this.writeByte((byte)(value >> 8));
    }

    public void writeInt(int value) {
        this.writeByte((byte)(value >> 24));
        this.writeByte((byte)(value >> 16));
        this.writeByte((byte)(value >> 8));
        this.writeByte((byte)value);
    }

    public void writeIntLE(int value) {
        this.writeByte((byte)value);
        this.writeByte((byte)(value >> 8));
        this.writeByte((byte)(value >> 16));
        this.writeByte((byte)(value >> 24));
    }

    public void writeBytes(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void close() {
    }
}

