/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.lang;

import java.util.LinkedList;
import java.util.List;
import xyz.noark.core.exception.IllegalExpressionException;
import xyz.noark.core.util.StringUtils;

public class IntRange {
    private final List<IntSection> sectionList = new LinkedList<IntSection>();

    public IntRange(String expression) {
        this.analysis(expression);
    }

    private void analysis(String expression) {
        if (StringUtils.isBlank(expression)) {
            return;
        }
        for (String x : StringUtils.split(expression, ",")) {
            if (StringUtils.isBlank(x)) continue;
            String[] array = StringUtils.split(x, "-");
            if (array.length == 1) {
                this.sectionList.add(new IntSection(Integer.parseInt(array[0])));
                continue;
            }
            if (array.length == 2) {
                this.sectionList.add(new IntSection(Integer.parseInt(array[0]), Integer.parseInt(array[1])));
                continue;
            }
            throw new IllegalExpressionException("\u6570\u5b57\u533a\u95f4\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\uff1a" + expression);
        }
    }

    public boolean contains(int element) {
        return this.sectionList.stream().filter(v -> v.contains(element)).findFirst().isPresent();
    }

    private class IntSection {
        private final int min;
        private final int max;

        public IntSection(int value) {
            this(value, value);
        }

        public IntSection(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean contains(int element) {
            return this.min <= element && element <= this.max;
        }

        public String toString() {
            return "IntSection [min=" + this.min + ", max=" + this.max + "]";
        }
    }
}

