/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import java.io.Serializable;
import xyz.noark.core.network.NetworkListener;
import xyz.noark.core.network.ResultHelper;
import xyz.noark.core.network.Session;
import xyz.noark.core.thread.TaskQueue;
import xyz.noark.core.thread.ThreadCommand;
import xyz.noark.core.util.ThreadUtils;
import xyz.noark.log.LogHelper;

public class AsyncTask
implements Runnable {
    protected final long createTime = System.nanoTime();
    protected final TaskQueue taskQueue;
    private final ThreadCommand command;
    private final Serializable playerId;
    private final NetworkListener networkListener;
    private final int reqId;
    private final Session session;
    private Thread currentThread;
    private long startExecuteTime;

    public AsyncTask(NetworkListener networkListener, TaskQueue taskQueue, ThreadCommand command, Serializable playerId, int reqId, Session session) {
        this.taskQueue = taskQueue;
        this.command = command;
        this.playerId = playerId;
        this.reqId = reqId;
        this.session = session;
        this.networkListener = networkListener;
    }

    @Override
    public void run() {
        this.startExecuteTime = System.nanoTime();
        this.currentThread = Thread.currentThread();
        try {
            ResultHelper.trySendResult(this.session, this.reqId, this.command.exec());
        }
        catch (Throwable e) {
            LogHelper.logger.error("handle {} exception.{}", new Object[]{this.command.code(), e});
            if (this.networkListener != null) {
                this.networkListener.handleException(this.session, this.reqId, e);
            }
        }
        finally {
            this.taskQueue.complete();
            this.execCommandAfter(this.startExecuteTime);
        }
    }

    private void execCommandAfter(long startExecuteTime) {
        if (this.command.isPrintLog()) {
            long endExecuteTime = System.nanoTime();
            if (this.playerId == null) {
                LogHelper.logger.info("handle {},delay={} ms,exec={} ms", new Object[]{this.command.code(), Float.valueOf((float)(startExecuteTime - this.createTime) / 1000000.0f), Float.valueOf((float)(endExecuteTime - startExecuteTime) / 1000000.0f)});
            } else {
                LogHelper.logger.info("handle {},delay={} ms,exec={} ms playerId={}", new Object[]{this.command.code(), Float.valueOf((float)(startExecuteTime - this.createTime) / 1000000.0f), Float.valueOf((float)(endExecuteTime - startExecuteTime) / 1000000.0f), this.playerId});
            }
        }
    }

    public void logExecTimeoutInfo(boolean outputStack) {
        long now = System.nanoTime();
        if (this.playerId == null) {
            LogHelper.logger.error("exec timeout {},delay={} ms,exec={} ms", new Object[]{this.command.code(), Float.valueOf((float)(this.startExecuteTime - this.createTime) / 1000000.0f), Float.valueOf((float)(now - this.startExecuteTime) / 1000000.0f)});
        } else {
            LogHelper.logger.error("exec timeout {},delay={} ms,exec={} ms playerId={}", new Object[]{this.command.code(), Float.valueOf((float)(this.startExecuteTime - this.createTime) / 1000000.0f), Float.valueOf((float)(now - this.startExecuteTime) / 1000000.0f), this.playerId});
        }
        if (outputStack) {
            LogHelper.logger.error(ThreadUtils.printStackTrace(this.currentThread));
        }
    }
}

