/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import xyz.noark.core.thread.AsyncTask;
import xyz.noark.core.thread.MonitorThreadPool;
import xyz.noark.core.thread.TaskQueue;
import xyz.noark.log.LogHelper;

public class MonitorTaskQueue
extends TaskQueue {
    private final MonitorThreadPool monitorThreadPool;
    private final int timeout;
    private final boolean outputStack;
    private final int max = 10;
    private int count = 0;

    public MonitorTaskQueue(MonitorThreadPool monitorThreadPool, ExecutorService threadPool, int timeout, boolean outputStack) {
        super(threadPool);
        this.timeout = timeout;
        this.outputStack = outputStack;
        this.monitorThreadPool = monitorThreadPool;
    }

    @Override
    protected void exec(AsyncTask task) {
        Future<?> future = this.getThreadPool().submit(task);
        this.monitor(future, task);
    }

    private void monitor(Future<?> future, AsyncTask task) {
        ExecutorService monitorService = this.getExecutorService();
        if (!monitorService.isShutdown()) {
            monitorService.execute(() -> this.startMonitorExecTimeoutTask(future, task));
        }
    }

    private ExecutorService getExecutorService() {
        return this.monitorThreadPool == null ? this.getThreadPool() : this.monitorThreadPool.getMonitorService();
    }

    private void startMonitorExecTimeoutTask(Future<?> future, AsyncTask task) {
        ++this.count;
        try {
            future.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            task.logExecTimeoutInfo(this.outputStack);
            if (10 > this.count) {
                this.monitor(future, task);
            }
            LogHelper.logger.warn("\u76d1\u63a7\u4efb\u52a1\u5df2\u6267\u884c10\u6b21\uff0c\u8fd8\u6ca1\u6709\u5b8c\u6210\uff0c\u51c6\u5907\u5f3a\u5236\u7ed3\u675f\u5f53\u524d\u4efb\u52a1.");
            future.cancel(true);
        }
    }
}

