/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadCounter = new AtomicInteger(1);
    private final String name;
    private final boolean hasSuffix;
    private final ThreadGroup group;

    public NamedThreadFactory(String name) {
        this(name, true);
    }

    public NamedThreadFactory(String name, boolean hasSuffix) {
        SecurityManager securitymanager = System.getSecurityManager();
        this.group = securitymanager == null ? Thread.currentThread().getThreadGroup() : securitymanager.getThreadGroup();
        this.name = name;
        this.hasSuffix = hasSuffix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread;
        StringBuilder threadName = new StringBuilder(56);
        threadName.append(this.name);
        if (this.hasSuffix) {
            threadName.append("-").append(this.threadCounter.getAndIncrement());
        }
        if ((thread = new Thread(this.group, runnable, threadName.toString())).isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

