/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import xyz.noark.core.util.Base64Utils;
import xyz.noark.core.util.CharsetUtils;
import xyz.noark.core.util.StringUtils;

public class AesUtils {
    private static final String ALGORITHM_AES = "AES";

    public static String encrypt(String text, String key) {
        return Base64Utils.encodeToString(AesUtils.encrypt(StringUtils.utf8Bytes(text), key));
    }

    public static byte[] encrypt(byte[] data, String key) {
        return AesUtils.doAes(data, 1, key);
    }

    public static String decrypt(String text, String key) {
        return new String(AesUtils.decrypt(Base64Utils.decode(text), key), CharsetUtils.CHARSET_UTF_8);
    }

    public static byte[] decrypt(byte[] data, String key) {
        return AesUtils.doAes(data, 2, key);
    }

    private static byte[] doAes(byte[] data, int mode, String key) {
        try {
            SecretKey secretKey = AesUtils.genSecretKey(key);
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES);
            cipher.init(mode, new SecretKeySpec(secretKey.getEncoded(), ALGORITHM_AES));
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal Argument.", e);
        }
    }

    private static SecretKey genSecretKey(String key) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(ALGORITHM_AES);
            kgen.init(128, new SecureRandom(key.getBytes()));
            return kgen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("illegal algorithm aes", e);
        }
    }
}

