/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.util.FieldUtils;
import xyz.noark.log.LogHelper;

public class AssertUtils {
    public static <T> void assertStringMaxLength(Collection<T> list, Function<T, String> stringFunc, int maxLength, String tips) {
        List<Object> result = list.stream().filter(v -> ((String)stringFunc.apply(v)).length() > maxLength).collect(Collectors.toList());
        if (!result.isEmpty()) {
            result.forEach(v -> LogHelper.logger.warn(tips, new Object[]{stringFunc.apply(v), maxLength}));
            throw new ServerBootstrapException("\u65ad\u8a00\u96c6\u5408\u4e2d\u5b57\u7b26\u4e32\u5c5e\u6027\u957f\u5ea6\u8d85\u51fa\u4e86\u6700\u5927\u9650\u5236\uff0c\u8bf7\u901f\u901f\u5904\u7406...");
        }
    }

    public static void assertConstantValueDuplicated(Class<?> klass) {
        List<Field> allField = FieldUtils.getAllField(klass);
        int totalNum = 0;
        HashMap<Object, Field> caches = new HashMap<Object, Field>(allField.size());
        for (Field field : allField) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
            ++totalNum;
            Object value = FieldUtils.readField(null, field);
            Optional.ofNullable(caches.put(value, field)).ifPresent(v -> LogHelper.logger.warn("\u5e38\u91cf\u7c7b[{}]\u4e2d\u91cd\u590d\u5b9a\u4e49\u7684\u503c value={}, field1={}, field2={}", new Object[]{klass.getName(), value, v.getName(), field.getName()}));
        }
        if (totalNum > caches.size()) {
            throw new ServerBootstrapException("\u65ad\u8a00\u5e38\u91cf\u7c7b\u4e2d\u6709\u91cd\u590d\u5b9a\u4e49\u7684\u503c\uff0c\u8bf7\u901f\u901f\u5904\u7406...");
        }
    }
}

