/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;

public class ByteBufUtils {
    public static void writeRawVarint32(ByteBuf out, int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                out.writeByte(value);
                return;
            }
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int readRawVarint32(ByteBuf in) {
        byte tmp = in.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = in.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = in.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = in.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = in.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        throw new CorruptedFrameException("malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    public static String readString(ByteBuf in, int length) {
        byte[] content = new byte[length];
        in.readBytes(content);
        return new String(content);
    }

    public static byte[] readBytes(ByteBuf in) {
        byte[] content = new byte[in.readableBytes()];
        in.readBytes(content);
        return content;
    }
}

