/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import xyz.noark.core.annotation.tpl.TplAttr;
import xyz.noark.core.converter.ConvertManager;
import xyz.noark.core.converter.Converter;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.exception.NoPublicFieldException;
import xyz.noark.core.exception.ServerBootstrapException;

public class FieldUtils {
    private static final int PREFIX_IS_METHOD_INDEX = 2;
    private static final int PREFIX_GET_METHOD_INDEX = 3;
    private static final int PREFIX_SET_METHOD_INDEX = 3;

    public static void writeField(Object target, Field field, Object value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ServerBootstrapException(target.getClass() + " \u7684 " + field.getName() + " \u5c5e\u6027\u65e0\u6cd5\u6ce8\u5165.", e);
        }
    }

    public static void writeField(Object target, String fieldName, Object value) {
        Field field = FieldUtils.getField(target.getClass(), fieldName);
        if (field == null) {
            throw new NoPublicFieldException("Class=" + target.getClass().getName() + ", field=" + fieldName + " not found.");
        }
        FieldUtils.writeField(target, field, value);
    }

    public static Object readField(Object target, Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(target);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ServerBootstrapException(target.getClass() + " \u7684 " + field.getName() + " \u5c5e\u6027\u65e0\u6cd5\u8bfb\u53d6.", e);
        }
    }

    public static Field getField(Class<?> klass, String fieldName) {
        for (Class<?> target = klass; target != Object.class; target = target.getSuperclass()) {
            for (Field field : target.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    public static List<Field> getAllField(Class<?> klass) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> target = klass; target != Object.class; target = target.getSuperclass()) {
            for (Field field : target.getDeclaredFields()) {
                result.add(field);
            }
        }
        return result;
    }

    public static String genGetMethodName(Field field) {
        int len = field.getName().length();
        if (field.getType() == Boolean.TYPE) {
            StringBuilder sb = new StringBuilder(len + 2);
            sb.append("is").append(field.getName());
            if (Character.isLowerCase(sb.charAt(2))) {
                sb.setCharAt(2, Character.toUpperCase(sb.charAt(2)));
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(len + 3);
        sb.append("get").append(field.getName());
        if (Character.isLowerCase(sb.charAt(3))) {
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        }
        return sb.toString();
    }

    public static String genSetMethodName(Field field) {
        int len = field.getName().length();
        StringBuilder sb = new StringBuilder(len + 3);
        sb.append("set").append(field.getName());
        if (Character.isLowerCase(sb.charAt(3))) {
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        }
        return sb.toString();
    }

    public static Field[] scanAllField(Class<?> klass, List<Class<? extends Annotation>> annotations) {
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        FieldUtils.scanField(klass, fieldMap, annotations);
        return fieldMap.values().toArray(new Field[fieldMap.size()]);
    }

    private static void scanField(Class<?> klass, Map<String, Field> fieldMap, List<Class<? extends Annotation>> annotations) {
        Class<?> superClass = klass.getSuperclass();
        if (!Object.class.equals(superClass)) {
            FieldUtils.scanField(superClass, fieldMap, annotations);
        }
        block0: for (Field f : klass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers()) || fieldMap.containsKey(f.getName()) || f.getName().startsWith("this$")) continue;
            for (Annotation a : f.getAnnotations()) {
                if (!annotations.contains(a.annotationType())) continue;
                fieldMap.put(f.getName(), f);
                continue block0;
            }
        }
    }

    public static <T> void injectionStaticField(Map<String, T> templates, Class<?> target, Function<T, String> fun) {
        for (Field field : target.getFields()) {
            TplAttr attr = field.getAnnotation(TplAttr.class);
            if (attr == null) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new ServerBootstrapException(target.getName() + " \u7684 " + field.getName() + " \u4e0d\u662f\u9759\u6001\u5c5e\u6027\uff0c\u65e0\u6cd5\u6ce8\u5165.");
            }
            T template = templates.get(attr.name());
            if (template == null) {
                if (!attr.required()) continue;
                throw new ServerBootstrapException(target.getName() + " \u7684 " + field.getName() + " \u4e3a\u5fc5\u9009\u53c2\u6570.");
            }
            Converter<?> converter = ConvertManager.getInstance().getConverter(field.getType());
            try {
                FieldUtils.writeField(null, field, converter.convert(field, fun.apply(template)));
            }
            catch (Exception e) {
                throw new ConvertException(target.getName() + " >> " + field.getName() + " >> " + fun.apply(template) + "-->" + converter.buildErrorMsg(), e);
            }
        }
    }
}

