/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import xyz.noark.core.exception.HttpAccessException;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;

public class HttpUtils {
    static final int DEFAULT_TIMEOUT = 3000;

    public static String get(String url) {
        return HttpUtils.get(url, 3000, Collections.emptyMap());
    }

    public static String get(String url, int timeout) {
        return HttpUtils.get(url, timeout, Collections.emptyMap());
    }

    public static String get(String url, Map<String, String> requestProperty) {
        return HttpUtils.get(url, 3000, requestProperty);
    }

    public static String get(String url, int timeout, Map<String, String> requestProperty) {
        LogHelper.logger.info("GET: url={}", new Object[]{url});
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setReadTimeout(timeout);
            requestProperty.forEach((key, value) -> connection.setRequestProperty((String)key, (String)value));
            connection.connect();
            String result = StringUtils.readString(connection.getInputStream());
            LogHelper.logger.info(result);
            return result;
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }

    public static String post(String url, String params) {
        return HttpUtils.post(url, params, 3000, Collections.emptyMap());
    }

    public static String post(String url, String params, int timeout) {
        return HttpUtils.post(url, params, timeout, Collections.emptyMap());
    }

    public static String post(String url, String params, Map<String, String> requestProperty) {
        return HttpUtils.post(url, params, 3000, requestProperty);
    }

    public static String post(String url, String params, int timeout, Map<String, String> requestProperty) {
        LogHelper.logger.info("POST: url={}, param={}", new Object[]{url, params});
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setReadTimeout(timeout);
            requestProperty.forEach((key, value) -> connection.setRequestProperty((String)key, (String)value));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.connect();
            if (StringUtils.isNotEmpty(params)) {
                try (PrintWriter out = new PrintWriter(connection.getOutputStream());){
                    out.print(params);
                    out.flush();
                }
            }
            String result = StringUtils.readString(connection.getInputStream());
            LogHelper.logger.info(result);
            return result;
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }
}

