/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import xyz.noark.core.exception.HttpAccessException;
import xyz.noark.core.util.StringUtils;
import xyz.noark.log.LogHelper;

public class HttpsUtils {
    public static String get(String url) {
        return HttpsUtils.get(url, 3000, Collections.emptyMap());
    }

    public static String get(String url, int timeout) {
        return HttpsUtils.get(url, timeout, Collections.emptyMap());
    }

    public static String get(String url, Map<String, String> requestProperty) {
        return HttpsUtils.get(url, 3000, requestProperty);
    }

    public static String get(String url, int timeout, Map<String, String> requestProperty) {
        LogHelper.logger.info("GET: url={}", new Object[]{url});
        try {
            HttpsURLConnection connection = HttpsUtils.createHttpsUrlConnection(url);
            connection.setRequestMethod("GET");
            connection.setReadTimeout(timeout);
            requestProperty.forEach((key, value) -> connection.setRequestProperty((String)key, (String)value));
            String result = StringUtils.readString(connection.getInputStream());
            LogHelper.logger.info(result);
            return result;
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }

    public static String post(String url, String params) {
        return HttpsUtils.post(url, params, 3000, Collections.emptyMap());
    }

    public static String post(String url, String params, int timeout) {
        return HttpsUtils.post(url, params, timeout, Collections.emptyMap());
    }

    public static String post(String url, String params, Map<String, String> requestProperty) {
        return HttpsUtils.post(url, params, 3000, requestProperty);
    }

    public static String post(String url, String params, int timeout, Map<String, String> requestProperty) {
        LogHelper.logger.info("POST: url={}, param={}", new Object[]{url, params});
        try {
            HttpsURLConnection connection = HttpsUtils.createHttpsUrlConnection(url);
            connection.setRequestMethod("POST");
            connection.setReadTimeout(timeout);
            requestProperty.forEach((key, value) -> connection.setRequestProperty((String)key, (String)value));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.connect();
            if (StringUtils.isNotEmpty(params)) {
                try (PrintWriter out = new PrintWriter(connection.getOutputStream());){
                    out.print(params);
                    out.flush();
                }
            }
            String result = StringUtils.readString(connection.getInputStream());
            LogHelper.logger.info(result);
            return result;
        }
        catch (Exception e) {
            throw new HttpAccessException(e);
        }
    }

    private static HttpsURLConnection createHttpsUrlConnection(String url) throws MalformedURLException, IOException, KeyManagementException, NoSuchAlgorithmException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        connection.setSSLSocketFactory(HttpsUtils.initSslSocketFactory(new DefaultTrustManager()));
        connection.setHostnameVerifier(new DefaultHostnameVerifier());
        return connection;
    }

    private static SSLSocketFactory initSslSocketFactory(TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sc.getSocketFactory();
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class DefaultHostnameVerifier
    implements HostnameVerifier {
        private DefaultHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

