/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.util;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import xyz.noark.core.lang.ImmutablePair;
import xyz.noark.core.lang.Pair;
import xyz.noark.core.util.ArrayUtils;
import xyz.noark.core.util.Base64Utils;
import xyz.noark.core.util.StringUtils;

public class RsaUtils {
    public static void main(String[] args) throws Exception {
        String password = ArrayUtils.isEmpty(args) ? "ps!see(3#K)shit!say(man)" : args[0];
        Pair<String, String> keyPair = RsaUtils.genKeyPair(512);
        System.out.println("privateKey:" + keyPair.getLeft());
        System.out.println("publicKey:" + keyPair.getRight());
        String p = RsaUtils.encrypt(keyPair.getLeft(), password);
        System.out.println("password:" + p);
        System.out.println(RsaUtils.decrypt(keyPair.getRight(), p));
    }

    public static String decrypt(String publickeyText, String ciphertext) {
        PublicKey publicKey = RsaUtils.getPublicKey(publickeyText);
        return RsaUtils.decrypt(publicKey, ciphertext);
    }

    public static PublicKey getPublicKey(String publicKeyText) {
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64Utils.decode(publicKeyText));
            return KeyFactory.getInstance("RSA", "SunRsaSign").generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal public key:" + publicKeyText, e);
        }
    }

    public static String decrypt(PublicKey publicKey, String ciphertext) {
        if (StringUtils.isEmpty(ciphertext)) {
            return ciphertext;
        }
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, publicKey);
            return new String(cipher.doFinal(Base64Utils.decode(ciphertext)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal ciphertext:" + ciphertext, e);
        }
    }

    public static String encrypt(String key, String plainText) throws Exception {
        return RsaUtils.encrypt(Base64Utils.decode(key), plainText);
    }

    public static String encrypt(byte[] keyBytes, String plainText) throws Exception {
        PrivateKey privateKey = KeyFactory.getInstance("RSA", "SunRsaSign").generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, privateKey);
        return Base64Utils.encodeToString(cipher.doFinal(plainText.getBytes("UTF-8")));
    }

    public static Pair<String, String> genKeyPair(int keysize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", "SunRsaSign");
        gen.initialize(keysize, new SecureRandom());
        KeyPair pair = gen.generateKeyPair();
        byte[] privateKey = pair.getPrivate().getEncoded();
        byte[] publicKey = pair.getPublic().getEncoded();
        return ImmutablePair.of(Base64Utils.encodeToString(privateKey), Base64Utils.encodeToString(publicKey));
    }
}

