/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import java.util.Arrays;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.AbstractConverter;
import xyz.noark.core.lang.DoubleArrayList;
import xyz.noark.core.lang.DoubleList;
import xyz.noark.core.util.StringUtils;

@TemplateConverter(value={DoubleList.class, DoubleArrayList.class})
public class DoubleListConverter
extends AbstractConverter<DoubleList> {
    @Override
    public DoubleList convert(String value) {
        if (StringUtils.isEmpty(value)) {
            return new DoubleArrayList();
        }
        String[] array = StringUtils.split(value, ",");
        DoubleArrayList result = new DoubleArrayList(array.length);
        Arrays.stream(array).forEach(v -> result.add(Double.parseDouble(v)));
        return result;
    }

    @Override
    public String buildErrorMsg() {
        return "Double\u7c7b\u578b\u7684\u6570\u7ec4\u5e94\u8be5\u662f\u4ee5\u82f1\u6587\u9017\u53f7\u5206\u9694\u7684\uff0c\u5982\uff1a1.0,3.2,4";
    }
}

