/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.converter.impl;

import java.time.LocalTime;
import xyz.noark.core.annotation.TemplateConverter;
import xyz.noark.core.converter.AbstractConverter;
import xyz.noark.core.exception.ConvertException;
import xyz.noark.core.util.StringUtils;

@TemplateConverter(value={LocalTime.class})
public class LocalTimeConverter
extends AbstractConverter<LocalTime> {
    @Override
    public String buildErrorMsg() {
        return "\u683c\u5f0f\t08:00,16:00,22:00";
    }

    @Override
    public LocalTime convert(String value) {
        String[] ts = StringUtils.split(value, ":");
        if (ts.length == 2) {
            return LocalTime.of(Integer.parseInt(ts[0]), Integer.parseInt(ts[1]));
        }
        if (ts.length == 3) {
            return LocalTime.of(Integer.parseInt(ts[0]), Integer.parseInt(ts[1]), Integer.parseInt(ts[2]));
        }
        if (ts.length == 4) {
            return LocalTime.of(Integer.parseInt(ts[0]), Integer.parseInt(ts[1]), Integer.parseInt(ts[2]), Integer.parseInt(ts[3]));
        }
        throw new ConvertException("\u65f6\u95f4\u914d\u7f6e2\u4f4d'08:00,12:00,22:00'\u62163\u4f4d'08:00:00,12:00:00,22:00:00'");
    }
}

