/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.definition.field;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Optional;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.FieldDefinition;
import xyz.noark.core.ioc.IocMaking;
import xyz.noark.core.ioc.definition.DefaultBeanDefinition;
import xyz.noark.core.util.FieldUtils;

public class DefaultFieldDefinition
implements FieldDefinition {
    protected final Field field;
    protected final boolean required;
    protected final Class<?> fieldClass;

    public DefaultFieldDefinition(Field field, boolean required) {
        this(field, field.getType(), required);
    }

    protected DefaultFieldDefinition(Field field, Class<?> fieldClass, boolean required) {
        this.field = field;
        this.required = required;
        this.fieldClass = fieldClass;
        this.field.setAccessible(true);
    }

    @Override
    public void injection(Object single, IocMaking making) {
        FieldUtils.writeField(single, this.field, this.extractInjectionObject(making, this.field.getType(), this.field));
    }

    protected Object extractInjectionObject(IocMaking making, Class<?> klass, Field field) {
        Optional<Object> result = making.findAllImpl(klass).stream().sorted(Comparator.comparingInt(DefaultBeanDefinition::getOrder)).limit(1L).map(DefaultBeanDefinition::getSingle).findFirst();
        if (this.required) {
            return result.orElseThrow(() -> new ServerBootstrapException("Class:" + field.getDeclaringClass().getName() + ">>Field:" + field.getName() + " cannot autowired"));
        }
        return result.orElse(null);
    }
}

