/*
 * Decompiled with CFR 0.152.
 */
package xyz.noark.core.ioc.manager;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import xyz.noark.core.annotation.controller.RequestMethod;
import xyz.noark.core.exception.ServerBootstrapException;
import xyz.noark.core.ioc.wrap.method.HttpMethodWrapper;

public class HttpMethodManager {
    private static final EnumMap<RequestMethod, Map<String, HttpMethodWrapper>> HANDLER_MAP = new EnumMap(RequestMethod.class);

    private HttpMethodManager() {
    }

    public static void registerHandler(HttpMethodWrapper handler) {
        if (handler.getPath().indexOf(" ") != -1) {
            throw new ServerBootstrapException("URI\u4e2d\u53d1\u73b0\u7a7a\u683c\uff1a" + handler.getPath());
        }
        Collection<RequestMethod> methodSet = handler.getMethodSet();
        if (methodSet.isEmpty()) {
            methodSet = Arrays.asList(RequestMethod.values());
        }
        for (RequestMethod v : methodSet) {
            Map handlers = HANDLER_MAP.computeIfAbsent(v, key -> new HashMap(512));
            if (handlers.containsKey(handler.getPath())) {
                throw new ServerBootstrapException("\u91cd\u590d\u5b9a\u4e49\u7684URI\uff1a" + handler.getPath());
            }
            handlers.put(handler.getPath(), handler);
        }
    }

    public static HttpMethodWrapper getHttpHandler(String method, String path) {
        RequestMethod requestMethod = RequestMethod.valueOf(method.toUpperCase());
        return (HttpMethodWrapper)HANDLER_MAP.getOrDefault((Object)requestMethod, Collections.emptyMap()).get(path);
    }
}

